/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth;

import java.time.Duration;
import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.auth.AwsCredentials;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.utils.cache.CachedSupplier;
import software.amazon.awssdk.utils.cache.RefreshResult;

@SdkInternalApi
abstract class FileSystemCredentialsProvider
implements AwsCredentialsProvider {
    private CachedSupplier<AwsCredentials> cachedCredentials = CachedSupplier.builder(this::refreshCredentials).build();

    protected FileSystemCredentialsProvider() {
    }

    private RefreshResult<AwsCredentials> refreshCredentials() {
        return RefreshResult.builder(this.loadCredentials()).prefetchTime(Instant.now().plus(Duration.ofMinutes(5L))).build();
    }

    protected abstract AwsCredentials loadCredentials();

    @Override
    public final AwsCredentials getCredentials() {
        return this.cachedCredentials.get();
    }
}

