/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.auth.AwsCredentials;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.auth.EC2CredentialsProvider;
import software.amazon.awssdk.internal.CredentialsEndpointProvider;
import software.amazon.awssdk.internal.EC2CredentialsUtils;
import software.amazon.awssdk.util.EC2MetadataUtils;

public class InstanceProfileCredentialsProvider
implements AwsCredentialsProvider,
AutoCloseable {
    private final EC2CredentialsProvider credentialsFetcher;

    @ReviewBeforeRelease(value="This is inconsistent with client builders. Should this be a static create method?")
    public InstanceProfileCredentialsProvider() {
        this(InstanceProfileCredentialsProvider.builder());
    }

    private InstanceProfileCredentialsProvider(Builder builder) {
        this.credentialsFetcher = new EC2CredentialsProvider(new InstanceMetadataCredentialsEndpointProvider(), builder.asyncCredentialUpdateEnabled, "instance-profile-credentials-provider");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public AwsCredentials getCredentials() {
        return this.credentialsFetcher.getCredentials();
    }

    @Override
    public void close() {
        this.credentialsFetcher.close();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static final class Builder {
        private Boolean asyncCredentialUpdateEnabled = false;

        private Builder() {
        }

        public Builder asyncCredentialUpdateEnabled(Boolean asyncCredentialUpdateEnabled) {
            this.asyncCredentialUpdateEnabled = asyncCredentialUpdateEnabled;
            return this;
        }

        public InstanceProfileCredentialsProvider build() {
            return new InstanceProfileCredentialsProvider(this);
        }
    }

    private static class InstanceMetadataCredentialsEndpointProvider
    extends CredentialsEndpointProvider {
        private InstanceMetadataCredentialsEndpointProvider() {
        }

        @Override
        public URI getCredentialsEndpoint() throws URISyntaxException, IOException {
            String host = EC2MetadataUtils.getHostAddressForEc2MetadataService();
            URI endpoint = new URI(host + "/latest/meta-data/iam/security-credentials/");
            String securityCredentialsList = EC2CredentialsUtils.getInstance().readResource(endpoint);
            String[] securityCredentials = securityCredentialsList.trim().split("\n");
            if (securityCredentials.length == 0) {
                throw new SdkClientException("Unable to load credentials path");
            }
            return new URI(host + "/latest/meta-data/iam/security-credentials/" + securityCredentials[0]);
        }
    }
}

