/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth;

import software.amazon.awssdk.auth.AwsCredentials;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.metrics.spi.AwsRequestMetrics;
import software.amazon.awssdk.utils.Validate;

public class MetricsReportingCredentialsProvider
implements AwsCredentialsProvider {
    private final AwsCredentialsProvider delegate;
    private final AwsRequestMetrics awsRequestMetrics;

    public MetricsReportingCredentialsProvider(AwsCredentialsProvider delegate, AwsRequestMetrics awsRequestMetrics) {
        this.delegate = Validate.notNull(delegate, "Delegate must not be null.", new Object[0]);
        this.awsRequestMetrics = Validate.notNull(awsRequestMetrics, "Metrics must not be null.", new Object[0]);
    }

    @Override
    public AwsCredentials getCredentials() {
        this.awsRequestMetrics.startEvent(AwsRequestMetrics.Field.CredentialsRequestTime);
        try {
            AwsCredentials awsCredentials = this.delegate.getCredentials();
            return awsCredentials;
        }
        finally {
            this.awsRequestMetrics.endEvent(AwsRequestMetrics.Field.CredentialsRequestTime);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.delegate + ")";
    }
}

