/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.auth.AbstractAwsSigner;
import software.amazon.awssdk.auth.AwsCredentials;
import software.amazon.awssdk.auth.AwsSessionCredentials;
import software.amazon.awssdk.auth.SigningAlgorithm;
import software.amazon.awssdk.handlers.AwsHandlerKeys;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.util.CredentialUtils;

public class QueryStringSigner
extends AbstractAwsSigner {
    private Date overriddenDate;

    @Override
    public SdkHttpFullRequest sign(SdkHttpFullRequest request, AwsCredentials credentials) throws SdkClientException {
        return (SdkHttpFullRequest)this.sign((SdkHttpFullRequest.Builder)request.toBuilder(), SigningAlgorithm.HmacSHA256, credentials).build();
    }

    private SdkHttpFullRequest.Builder sign(SdkHttpFullRequest.Builder mutableRequest, SigningAlgorithm algorithm, AwsCredentials credentials) throws SdkClientException {
        if (CredentialUtils.isAnonymous(credentials)) {
            return mutableRequest;
        }
        AwsCredentials sanitizedCredentials = this.sanitizeCredentials(credentials);
        mutableRequest.queryParameter("AWSAccessKeyId", sanitizedCredentials.accessKeyId());
        mutableRequest.queryParameter("SignatureVersion", "2");
        int timeOffset = mutableRequest.handlerContext(AwsHandlerKeys.TIME_OFFSET) == null ? 0 : mutableRequest.handlerContext(AwsHandlerKeys.TIME_OFFSET);
        mutableRequest.queryParameter("Timestamp", this.getFormattedTimestamp(timeOffset));
        if (sanitizedCredentials instanceof AwsSessionCredentials) {
            this.addSessionCredentials(mutableRequest, (AwsSessionCredentials)sanitizedCredentials);
        }
        mutableRequest.queryParameter("SignatureMethod", algorithm.toString());
        String stringToSign = this.calculateStringToSignV2(mutableRequest);
        String signatureValue = this.signAndBase64Encode(stringToSign, sanitizedCredentials.secretAccessKey(), algorithm);
        mutableRequest.queryParameter("Signature", signatureValue);
        return mutableRequest;
    }

    private String calculateStringToSignV2(SdkHttpRequest request) throws SdkClientException {
        return "POST" + "\n" + this.getCanonicalizedEndpoint(request.getEndpoint()) + "\n" + this.getCanonicalizedResourcePath(request) + "\n" + this.getCanonicalizedQueryString(request.getParameters());
    }

    private String getCanonicalizedResourcePath(SdkHttpRequest request) {
        String resourcePath = "";
        if (request.getEndpoint().getPath() != null) {
            resourcePath = resourcePath + request.getEndpoint().getPath();
        }
        if (request.getResourcePath() != null) {
            if (resourcePath.length() > 0 && !resourcePath.endsWith("/") && !request.getResourcePath().startsWith("/")) {
                resourcePath = resourcePath + "/";
            }
            resourcePath = resourcePath + request.getResourcePath();
        } else if (!resourcePath.endsWith("/")) {
            resourcePath = resourcePath + "/";
        }
        if (!resourcePath.startsWith("/")) {
            resourcePath = "/" + resourcePath;
        }
        if (resourcePath.startsWith("//")) {
            resourcePath = resourcePath.substring(1);
        }
        return resourcePath;
    }

    private String getFormattedTimestamp(int offset) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (this.overriddenDate != null) {
            return df.format(this.overriddenDate);
        }
        return df.format(this.getSignatureDate(offset));
    }

    void overrideDate(Date date) {
        this.overriddenDate = date;
    }

    @Override
    protected void addSessionCredentials(SdkHttpFullRequest.Builder request, AwsSessionCredentials credentials) {
        request.queryParameter("SecurityToken", credentials.sessionToken());
    }
}

