/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.policy.conditions;

import java.util.Arrays;
import java.util.Date;
import software.amazon.awssdk.auth.policy.Condition;
import software.amazon.awssdk.util.DateUtils;

public class DateCondition
extends Condition {
    public DateCondition(DateComparisonType type, Date date) {
        this.type = type.toString();
        this.conditionKey = "aws:CurrentTime";
        this.values = Arrays.asList(DateUtils.formatIso8601Date(date));
    }

    public static enum DateComparisonType {
        DateEquals,
        DateGreaterThan,
        DateGreaterThanEquals,
        DateLessThan,
        DateLessThanEquals,
        DateNotEquals;

    }
}

