/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.profile.internal;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.Immutable;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.auth.AwsCredentials;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.auth.AwsSessionCredentials;
import software.amazon.awssdk.auth.StaticCredentialsProvider;
import software.amazon.awssdk.auth.profile.internal.BasicProfile;
import software.amazon.awssdk.util.StringUtils;

@SdkInternalApi
@Immutable
public class ProfileStaticCredentialsProvider
implements AwsCredentialsProvider {
    private final BasicProfile profile;
    private final AwsCredentialsProvider credentialsProvider;

    public ProfileStaticCredentialsProvider(BasicProfile profile) {
        this.profile = profile;
        this.credentialsProvider = new StaticCredentialsProvider(this.fromStaticCredentials());
    }

    @Override
    public AwsCredentials getCredentials() {
        return this.credentialsProvider.getCredentials();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.credentialsProvider + ")";
    }

    private AwsCredentials fromStaticCredentials() {
        if (StringUtils.isNullOrEmpty(this.profile.getAwsAccessIdKey())) {
            throw new SdkClientException(String.format("Unable to load credentials into profile [%s]: AWS Access Key ID is not specified.", this.profile.getProfileName()));
        }
        if (StringUtils.isNullOrEmpty(this.profile.getAwsSecretAccessKey())) {
            throw new SdkClientException(String.format("Unable to load credentials into profile [%s]: AWS Secret Access Key is not specified.", this.profile.getAwsSecretAccessKey()));
        }
        if (this.profile.getAwsSessionToken() == null) {
            return new AwsCredentials(this.profile.getAwsAccessIdKey(), this.profile.getAwsSecretAccessKey());
        }
        if (this.profile.getAwsSessionToken().isEmpty()) {
            throw new SdkClientException(String.format("Unable to load credentials into profile [%s]: AWS Session Token is empty.", this.profile.getProfileName()));
        }
        return new AwsSessionCredentials(this.profile.getAwsAccessIdKey(), this.profile.getAwsSecretAccessKey(), this.profile.getAwsSessionToken());
    }
}

