/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.client;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.RequestConfig;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.annotation.Immutable;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.async.AsyncRequestProvider;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.client.AsyncClientHandler;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.handlers.AwsHandlerKeys;
import software.amazon.awssdk.handlers.RequestHandler;
import software.amazon.awssdk.http.AmazonAsyncHttpClient;
import software.amazon.awssdk.http.ExecutionContext;
import software.amazon.awssdk.http.HttpResponse;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullRequestAdapter;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpResponseAdapter;
import software.amazon.awssdk.http.async.SdkHttpRequestProvider;
import software.amazon.awssdk.http.async.SdkHttpResponseHandler;
import software.amazon.awssdk.http.async.SyncResponseHandlerAdapter;
import software.amazon.awssdk.metrics.AwsSdkMetrics;
import software.amazon.awssdk.metrics.RequestMetricCollector;
import software.amazon.awssdk.metrics.spi.AwsRequestMetrics;
import software.amazon.awssdk.runtime.auth.SignerProvider;
import software.amazon.awssdk.util.CredentialUtils;
import software.amazon.awssdk.util.Throwables;

@Immutable
@ThreadSafe
@SdkProtectedApi
public class AsyncClientHandlerImpl
extends AsyncClientHandler {
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final SignerProvider signerProvider;
    private final URI endpoint;
    private final List<RequestHandler> requestHandlers;
    private final RequestMetricCollector clientLevelMetricCollector;
    private final AmazonAsyncHttpClient client;
    private final boolean calculateCrc32FromCompressedData;

    public AsyncClientHandlerImpl(ClientHandlerParams handlerParams) {
        this.signerProvider = handlerParams.getClientParams().getSignerProvider();
        this.endpoint = handlerParams.getClientParams().getEndpoint();
        this.awsCredentialsProvider = handlerParams.getClientParams().getCredentialsProvider();
        this.requestHandlers = handlerParams.getClientParams().getRequestHandlers();
        this.clientLevelMetricCollector = handlerParams.getClientParams().getRequestMetricCollector();
        this.calculateCrc32FromCompressedData = handlerParams.isCalculateCrc32FromCompressedDataEnabled();
        this.client = this.buildHttpClient(handlerParams);
    }

    private AmazonAsyncHttpClient buildHttpClient(ClientHandlerParams handlerParams) {
        AwsSyncClientParams clientParams = handlerParams.getClientParams();
        return AmazonAsyncHttpClient.builder().clientConfiguration(clientParams.getClientConfiguration()).retryPolicy(clientParams.getRetryPolicy()).requestMetricCollector(clientParams.getRequestMetricCollector()).calculateCrc32FromCompressedData(handlerParams.isCalculateCrc32FromCompressedDataEnabled()).asyncExecutor(handlerParams.getAsyncClientParams().getExecutor()).sdkAsyncHttpClient(handlerParams.getAsyncClientParams().getAsyncHttpClient()).build();
    }

    @Override
    public <InputT, OutputT> CompletableFuture<OutputT> execute(ClientExecutionParams<InputT, OutputT> executionParams) {
        Request request;
        InputT inputT = executionParams.getInput();
        ExecutionContext executionContext = this.createExecutionContext(executionParams.getRequestConfig());
        AwsRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AwsRequestMetrics.Field.ClientExecuteTime);
        awsRequestMetrics.startEvent(AwsRequestMetrics.Field.RequestMarshallTime);
        try {
            request = executionParams.getMarshaller().marshall(this.tryBeforeMarshalling(inputT));
            request.setAwsRequestMetrics(awsRequestMetrics);
            request.setEndpoint(this.endpoint);
        }
        catch (Exception e) {
            this.endClientExecution(awsRequestMetrics, executionParams.getRequestConfig(), null, null);
            throw e;
        }
        finally {
            awsRequestMetrics.endEvent(AwsRequestMetrics.Field.RequestMarshallTime);
        }
        SdkHttpFullRequest marshalled = (SdkHttpFullRequest)SdkHttpFullRequestAdapter.toMutableHttpFullRequest(request).handlerContext(AwsHandlerKeys.REQUEST_CONFIG, executionParams.getRequestConfig()).build();
        SdkHttpRequestProvider requestProvider = executionParams.getAsyncRequestProvider() != null ? this.adaptAsyncRequestProvider(executionParams.getAsyncRequestProvider()) : null;
        Function<SdkHttpFullResponse, HttpResponse> responseAdapter = r -> SdkHttpResponseAdapter.adapt(this.calculateCrc32FromCompressedData, marshalled, r);
        SdkHttpResponseHandler<OutputT> responseHandler = this.resolveResponseHandler(executionParams, responseAdapter);
        SdkHttpResponseHandler<? extends SdkBaseException> errorHandler = this.resolveErrorResponseHandler(executionParams, responseAdapter);
        return this.invoke(marshalled, requestProvider, executionParams.getRequestConfig(), executionContext, responseHandler, errorHandler).handle((resp, err) -> {
            try {
                if (err != null) {
                    throw Throwables.failure(err);
                }
                Object object = resp;
                return object;
            }
            finally {
                this.endClientExecution(awsRequestMetrics, executionParams.getRequestConfig(), request, resp);
            }
        });
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    private SdkHttpRequestProvider adaptAsyncRequestProvider(final AsyncRequestProvider asyncRequestProvider) {
        return new SdkHttpRequestProvider(){

            @Override
            public long contentLength() {
                return asyncRequestProvider.contentLength();
            }

            @Override
            public void subscribe(Subscriber<? super ByteBuffer> s) {
                asyncRequestProvider.subscribe(s);
            }
        };
    }

    private SdkHttpResponseHandler<? extends SdkBaseException> resolveErrorResponseHandler(ClientExecutionParams<?, ?> executionParams, Function<SdkHttpFullResponse, HttpResponse> responseAdapter) {
        return new SyncResponseHandlerAdapter<SdkBaseException>(executionParams.getErrorResponseHandler(), responseAdapter);
    }

    private <OutputT> SdkHttpResponseHandler<OutputT> resolveResponseHandler(ClientExecutionParams<?, OutputT> executionParams, Function<SdkHttpFullResponse, HttpResponse> responseAdapter) {
        return executionParams.getResponseHandler() != null ? new SyncResponseHandlerAdapter<OutputT>(executionParams.getResponseHandler(), responseAdapter) : executionParams.getAsyncResponseHandler();
    }

    private ExecutionContext createExecutionContext(RequestConfig requestConfig) {
        boolean isMetricsEnabled = this.isRequestMetricsEnabled(requestConfig);
        return ExecutionContext.builder().withRequestHandlers(this.requestHandlers).withUseRequestMetrics(isMetricsEnabled).withSignerProvider(this.signerProvider).build();
    }

    private boolean isRequestMetricsEnabled(RequestConfig requestConfig) {
        return this.hasRequestMetricsCollector(requestConfig) || this.isRmcEnabledAtClientOrSdkLevel();
    }

    private boolean hasRequestMetricsCollector(RequestConfig requestConfig) {
        return requestConfig.getRequestMetricsCollector() != null && requestConfig.getRequestMetricsCollector().isEnabled();
    }

    private boolean isRmcEnabledAtClientOrSdkLevel() {
        RequestMetricCollector collector = this.requestMetricCollector();
        return collector != null && collector.isEnabled();
    }

    private RequestMetricCollector requestMetricCollector() {
        return this.clientLevelMetricCollector != null ? this.clientLevelMetricCollector : AwsSdkMetrics.getRequestMetricCollector();
    }

    @ReviewBeforeRelease(value="This should be removed when we update the listener system.")
    private <T> T tryBeforeMarshalling(T input) {
        if (input instanceof AmazonWebServiceRequest) {
            return (T)this.beforeMarshalling((AmazonWebServiceRequest)input);
        }
        return input;
    }

    private <T extends AmazonWebServiceRequest> T beforeMarshalling(T request) {
        Object local = request;
        for (RequestHandler handler : this.requestHandlers) {
            local = handler.beforeMarshalling((AmazonWebServiceRequest)local);
        }
        return local;
    }

    private <OutputT> CompletableFuture<OutputT> invoke(SdkHttpFullRequest request, SdkHttpRequestProvider requestProvider, RequestConfig requestConfig, ExecutionContext executionContext, SdkHttpResponseHandler<OutputT> responseHandler, SdkHttpResponseHandler<? extends SdkBaseException> errorResponseHandler) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(requestConfig, this.awsCredentialsProvider));
        return this.doInvoke(request, requestProvider, requestConfig, executionContext, responseHandler, errorResponseHandler);
    }

    private <OutputT> CompletableFuture<OutputT> doInvoke(SdkHttpFullRequest request, SdkHttpRequestProvider requestProvider, RequestConfig requestConfig, ExecutionContext executionContext, SdkHttpResponseHandler<OutputT> responseHandler, SdkHttpResponseHandler<? extends SdkBaseException> errorResponseHandler) {
        return this.client.requestExecutionBuilder().requestProvider(requestProvider).request(request).requestConfig(requestConfig).executionContext(executionContext).errorResponseHandler(errorResponseHandler).execute(responseHandler);
    }

    private void endClientExecution(AwsRequestMetrics awsRequestMetrics, RequestConfig requestConfig, Request<?> request, Object response) {
        if (request != null) {
            awsRequestMetrics.endEvent(AwsRequestMetrics.Field.ClientExecuteTime);
            awsRequestMetrics.getTimingInfo().endTiming();
            RequestMetricCollector metricCollector = this.findRequestMetricCollector(requestConfig);
            metricCollector.collectMetrics(request, response);
            awsRequestMetrics.log();
        }
    }

    private RequestMetricCollector findRequestMetricCollector(RequestConfig requestConfig) {
        RequestMetricCollector reqLevelMetricsCollector = requestConfig.getRequestMetricsCollector();
        if (reqLevelMetricsCollector != null) {
            return reqLevelMetricsCollector;
        }
        if (this.clientLevelMetricCollector != null) {
            return this.clientLevelMetricCollector;
        }
        return AwsSdkMetrics.getRequestMetricCollector();
    }
}

