/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.client;

import java.net.URI;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.RequestConfig;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.ServiceAdvancedConfiguration;
import software.amazon.awssdk.annotation.Immutable;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.handlers.AwsHandlerKeys;
import software.amazon.awssdk.handlers.RequestHandler;
import software.amazon.awssdk.http.AmazonHttpClient;
import software.amazon.awssdk.http.ExecutionContext;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullRequestAdapter;
import software.amazon.awssdk.metrics.AwsSdkMetrics;
import software.amazon.awssdk.metrics.RequestMetricCollector;
import software.amazon.awssdk.metrics.spi.AwsRequestMetrics;
import software.amazon.awssdk.runtime.auth.SignerProvider;
import software.amazon.awssdk.util.CredentialUtils;

@Immutable
@ThreadSafe
@SdkProtectedApi
public class ClientHandlerImpl
extends ClientHandler {
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final SignerProvider signerProvider;
    private final URI endpoint;
    private final List<RequestHandler> requestHandlers;
    private final RequestMetricCollector clientLevelMetricCollector;
    private final ServiceAdvancedConfiguration serviceAdvancedConfiguration;
    private final AmazonHttpClient client;

    public ClientHandlerImpl(ClientHandlerParams handlerParams) {
        this.signerProvider = handlerParams.getClientParams().getSignerProvider();
        this.endpoint = handlerParams.getClientParams().getEndpoint();
        this.awsCredentialsProvider = handlerParams.getClientParams().getCredentialsProvider();
        this.requestHandlers = handlerParams.getClientParams().getRequestHandlers();
        this.clientLevelMetricCollector = handlerParams.getClientParams().getRequestMetricCollector();
        this.serviceAdvancedConfiguration = handlerParams.getServiceAdvancedConfiguration();
        this.client = this.buildHttpClient(handlerParams);
    }

    private AmazonHttpClient buildHttpClient(ClientHandlerParams handlerParams) {
        AwsSyncClientParams clientParams = handlerParams.getClientParams();
        return AmazonHttpClient.builder().clientConfiguration(clientParams.getClientConfiguration()).retryPolicy(clientParams.getRetryPolicy()).requestMetricCollector(clientParams.getRequestMetricCollector()).calculateCrc32FromCompressedData(handlerParams.isCalculateCrc32FromCompressedDataEnabled()).sdkHttpClient(handlerParams.getClientParams().sdkHttpClient()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <InputT, OutputT> OutputT execute(ClientExecutionParams<InputT, OutputT> executionParams) {
        InputT inputT = executionParams.getInput();
        ExecutionContext executionContext = this.createExecutionContext(executionParams.getRequestConfig());
        AwsRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AwsRequestMetrics.Field.ClientExecuteTime);
        Request<InputT> request = null;
        OutputT response = null;
        try {
            awsRequestMetrics.startEvent(AwsRequestMetrics.Field.RequestMarshallTime);
            try {
                request = executionParams.getMarshaller().marshall(this.tryBeforeMarshalling(inputT));
                request.setAwsRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(AwsHandlerKeys.SERVICE_ADVANCED_CONFIG, this.serviceAdvancedConfiguration);
            }
            finally {
                awsRequestMetrics.endEvent(AwsRequestMetrics.Field.RequestMarshallTime);
            }
            SdkHttpFullRequest marshalled = (SdkHttpFullRequest)SdkHttpFullRequestAdapter.toMutableHttpFullRequest(request).handlerContext(AwsHandlerKeys.REQUEST_CONFIG, executionParams.getRequestConfig()).endpoint(this.endpoint).build();
            OutputT OutputT = response = (OutputT)this.invoke(marshalled, executionParams.getRequestConfig(), executionContext, executionParams.getResponseHandler(), executionParams.getErrorResponseHandler());
            return OutputT;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, executionParams.getRequestConfig(), request, response);
        }
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    private ExecutionContext createExecutionContext(RequestConfig requestConfig) {
        boolean isMetricsEnabled = this.isRequestMetricsEnabled(requestConfig);
        return ExecutionContext.builder().withRequestHandlers(this.requestHandlers).withUseRequestMetrics(isMetricsEnabled).withSignerProvider(this.signerProvider).build();
    }

    private boolean isRequestMetricsEnabled(RequestConfig requestConfig) {
        return this.hasRequestMetricsCollector(requestConfig) || this.isRmcEnabledAtClientOrSdkLevel();
    }

    private boolean hasRequestMetricsCollector(RequestConfig requestConfig) {
        return requestConfig.getRequestMetricsCollector() != null && requestConfig.getRequestMetricsCollector().isEnabled();
    }

    private boolean isRmcEnabledAtClientOrSdkLevel() {
        RequestMetricCollector collector = this.requestMetricCollector();
        return collector != null && collector.isEnabled();
    }

    private RequestMetricCollector requestMetricCollector() {
        return this.clientLevelMetricCollector != null ? this.clientLevelMetricCollector : AwsSdkMetrics.getRequestMetricCollector();
    }

    @ReviewBeforeRelease(value="This should be removed when we update the listener system.")
    private <T> T tryBeforeMarshalling(T input) {
        if (input instanceof AmazonWebServiceRequest) {
            return (T)this.beforeMarshalling((AmazonWebServiceRequest)input);
        }
        return input;
    }

    private <T extends AmazonWebServiceRequest> T beforeMarshalling(T request) {
        Object local = request;
        for (RequestHandler handler : this.requestHandlers) {
            local = handler.beforeMarshalling((AmazonWebServiceRequest)local);
        }
        return local;
    }

    private <OutputT> OutputT invoke(SdkHttpFullRequest request, RequestConfig requestConfig, ExecutionContext executionContext, HttpResponseHandler<OutputT> responseHandler, HttpResponseHandler<? extends SdkBaseException> errorResponseHandler) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(requestConfig, this.awsCredentialsProvider));
        return this.doInvoke(request, requestConfig, executionContext, responseHandler, errorResponseHandler);
    }

    private <OutputT> OutputT doInvoke(SdkHttpFullRequest request, RequestConfig requestConfig, ExecutionContext executionContext, HttpResponseHandler<OutputT> responseHandler, HttpResponseHandler<? extends SdkBaseException> errorResponseHandler) {
        return this.client.requestExecutionBuilder().request(request).requestConfig(requestConfig).executionContext(executionContext).errorResponseHandler(errorResponseHandler).execute(responseHandler);
    }

    private void endClientExecution(AwsRequestMetrics awsRequestMetrics, RequestConfig requestConfig, Request<?> request, Object response) {
        if (request != null) {
            awsRequestMetrics.endEvent(AwsRequestMetrics.Field.ClientExecuteTime);
            awsRequestMetrics.getTimingInfo().endTiming();
            RequestMetricCollector metricCollector = this.findRequestMetricCollector(requestConfig);
            metricCollector.collectMetrics(request, response);
            awsRequestMetrics.log();
        }
    }

    private RequestMetricCollector findRequestMetricCollector(RequestConfig requestConfig) {
        RequestMetricCollector reqLevelMetricsCollector = requestConfig.getRequestMetricsCollector();
        if (reqLevelMetricsCollector != null) {
            return reqLevelMetricsCollector;
        }
        if (this.clientLevelMetricCollector != null) {
            return this.clientLevelMetricCollector;
        }
        return AwsSdkMetrics.getRequestMetricCollector();
    }
}

