/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.config;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.config.AdvancedClientOption;
import software.amazon.awssdk.handlers.RequestHandler;
import software.amazon.awssdk.metrics.RequestMetricCollector;
import software.amazon.awssdk.retry.RetryPolicy;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ClientOverrideConfiguration
implements ToCopyableBuilder<Builder, ClientOverrideConfiguration> {
    private final Duration httpRequestTimeout;
    private final Duration totalExecutionTimeout;
    private final Map<String, List<String>> additionalHttpHeaders;
    private final Boolean gzipEnabled;
    private final RequestMetricCollector requestMetricCollector;
    private final RetryPolicy retryPolicy;
    private final List<RequestHandler> requestListeners;
    private final AttributeMap advancedOptions;

    private ClientOverrideConfiguration(DefaultClientOverrideConfigurationBuilder builder) {
        this.httpRequestTimeout = builder.httpRequestTimeout;
        this.totalExecutionTimeout = builder.totalExecutionTimeout;
        this.additionalHttpHeaders = CollectionUtils.deepCopiedUnmodifiableMap(builder.additionalHttpHeaders);
        this.gzipEnabled = builder.gzipEnabled;
        this.requestMetricCollector = builder.requestMetricCollector;
        this.retryPolicy = builder.retryPolicy;
        this.requestListeners = Collections.unmodifiableList(new ArrayList(builder.requestListeners));
        this.advancedOptions = builder.advancedOptions.build();
    }

    @Override
    public Builder toBuilder() {
        return new DefaultClientOverrideConfigurationBuilder().advancedOptions(this.advancedOptions.toBuilder()).httpRequestTimeout(this.httpRequestTimeout).totalExecutionTimeout(this.totalExecutionTimeout).additionalHttpHeaders(this.additionalHttpHeaders).gzipEnabled(this.gzipEnabled).requestMetricCollector(this.requestMetricCollector).retryPolicy(this.retryPolicy).requestListeners(this.requestListeners);
    }

    public static Builder builder() {
        return new DefaultClientOverrideConfigurationBuilder();
    }

    public Duration httpRequestTimeout() {
        return this.httpRequestTimeout;
    }

    public Duration totalExecutionTimeout() {
        return this.totalExecutionTimeout;
    }

    public Map<String, List<String>> additionalHttpHeaders() {
        return this.additionalHttpHeaders;
    }

    public Boolean gzipEnabled() {
        return this.gzipEnabled;
    }

    public RequestMetricCollector requestMetricCollector() {
        return this.requestMetricCollector;
    }

    public RetryPolicy retryPolicy() {
        return this.retryPolicy;
    }

    public <T> T advancedOption(AdvancedClientOption<T> option) {
        return this.advancedOptions.get(option);
    }

    @ReviewBeforeRelease(value="We are probably going to update the request handler interface. The description should be updated to detail the functionality of the new interface.")
    public List<RequestHandler> requestListeners() {
        return this.requestListeners;
    }

    private static final class DefaultClientOverrideConfigurationBuilder
    implements Builder {
        private Duration httpRequestTimeout;
        private Duration totalExecutionTimeout;
        private Map<String, List<String>> additionalHttpHeaders = new HashMap<String, List<String>>();
        private Boolean gzipEnabled;
        private RequestMetricCollector requestMetricCollector;
        private RetryPolicy retryPolicy;
        private List<RequestHandler> requestListeners = new ArrayList<RequestHandler>();
        private AttributeMap.Builder advancedOptions = AttributeMap.builder();

        private DefaultClientOverrideConfigurationBuilder() {
        }

        @Override
        public Builder httpRequestTimeout(Duration httpRequestTimeout) {
            this.httpRequestTimeout = httpRequestTimeout;
            return this;
        }

        public void setHttpRequestTimeout(Duration httpRequestTimeout) {
            this.httpRequestTimeout(httpRequestTimeout);
        }

        @Override
        public Builder totalExecutionTimeout(Duration totalExecutionTimeout) {
            this.totalExecutionTimeout = totalExecutionTimeout;
            return this;
        }

        public void setTotalExecutionTimeout(Duration totalExecutionTimeout) {
            this.totalExecutionTimeout(totalExecutionTimeout);
        }

        @Override
        public Builder additionalHttpHeaders(Map<String, List<String>> additionalHttpHeaders) {
            this.additionalHttpHeaders = CollectionUtils.deepCopyMap(additionalHttpHeaders);
            return this;
        }

        @Override
        public Builder addAdditionalHttpHeader(String header, String ... values) {
            List currentHeaderValues = this.additionalHttpHeaders.computeIfAbsent(header, k -> new ArrayList());
            Collections.addAll(currentHeaderValues, values);
            return this;
        }

        public void setAdditionalHttpHeaders(Map<String, List<String>> additionalHttpHeaders) {
            this.additionalHttpHeaders(additionalHttpHeaders);
        }

        @Override
        public Builder gzipEnabled(Boolean gzipEnabled) {
            this.gzipEnabled = gzipEnabled;
            return this;
        }

        public void setGzipEnabled(Boolean gzipEnabled) {
            this.gzipEnabled(gzipEnabled);
        }

        @Override
        public Builder requestMetricCollector(RequestMetricCollector requestMetricCollector) {
            this.requestMetricCollector = requestMetricCollector;
            return this;
        }

        public void setRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
            this.requestMetricCollector(requestMetricCollector);
        }

        @Override
        public Builder retryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public void setRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy(retryPolicy);
        }

        @Override
        public Builder requestListeners(List<RequestHandler> requestListeners) {
            this.requestListeners.clear();
            this.requestListeners.addAll(requestListeners);
            return this;
        }

        @Override
        public Builder addRequestListener(RequestHandler requestListener) {
            this.requestListeners.add(requestListener);
            return this;
        }

        public void setRequestListeners(List<RequestHandler> requestListeners) {
            this.requestListeners(requestListeners);
        }

        @Override
        public <T> Builder advancedOption(AdvancedClientOption<T> option, T value) {
            this.advancedOptions.put(option, value);
            return this;
        }

        @Override
        public Builder advancedOptions(Map<AdvancedClientOption<?>, ?> advancedOptions) {
            this.advancedOptions.putAll(advancedOptions);
            return this;
        }

        private Builder advancedOptions(AttributeMap.Builder attributeMap) {
            this.advancedOptions = attributeMap;
            return this;
        }

        public void setAdvancedOptions(Map<AdvancedClientOption<?>, Object> advancedOptions) {
            this.advancedOptions(advancedOptions);
        }

        @Override
        public ClientOverrideConfiguration build() {
            return new ClientOverrideConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ClientOverrideConfiguration> {
        public Builder httpRequestTimeout(Duration var1);

        public Builder totalExecutionTimeout(Duration var1);

        public Builder additionalHttpHeaders(Map<String, List<String>> var1);

        public Builder addAdditionalHttpHeader(String var1, String ... var2);

        public Builder gzipEnabled(Boolean var1);

        public Builder requestMetricCollector(RequestMetricCollector var1);

        public Builder retryPolicy(RetryPolicy var1);

        public Builder requestListeners(List<RequestHandler> var1);

        public Builder addRequestListener(RequestHandler var1);

        public <T> Builder advancedOption(AdvancedClientOption<T> var1, T var2);

        public Builder advancedOptions(Map<AdvancedClientOption<?>, ?> var1);
    }
}

