/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.config.defaults;

import java.net.URI;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.config.ClientOverrideConfiguration;
import software.amazon.awssdk.config.MutableClientConfiguration;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkProtectedApi
public abstract class ClientConfigurationDefaults {
    public final void applySyncDefaults(MutableClientConfiguration config) {
        this.applyDefaultValues(config);
    }

    @ReviewBeforeRelease(value="Hardcodes thread pool default but that should go away anyways when we switch to NIO")
    public final void applyAsyncDefaults(MutableClientConfiguration config) {
        this.applyDefaultValues(config);
        config.asyncExecutorService(this.applyDefault(config.asyncExecutorService(), this::getAsyncExecutorDefault));
    }

    private void applyDefaultValues(MutableClientConfiguration config) {
        config.overrideConfiguration(this.applyDefaultValues(config.overrideConfiguration(), this::applyOverrideDefaults));
        config.credentialsProvider(this.applyDefault(config.credentialsProvider(), this::getCredentialsDefault));
        config.endpoint(this.applyDefault(config.endpoint(), this::getEndpointDefault));
    }

    protected void applyOverrideDefaults(ClientOverrideConfiguration.Builder builder) {
    }

    protected AwsCredentialsProvider getCredentialsDefault() {
        return null;
    }

    protected URI getEndpointDefault() {
        return null;
    }

    protected ScheduledExecutorService getAsyncExecutorDefault() {
        return null;
    }

    protected final <T> T applyDefault(T currentValue, Supplier<T> defaultValue) {
        return currentValue != null ? currentValue : defaultValue.get();
    }

    private <T extends ToCopyableBuilder<B, T>, B extends CopyableBuilder<B, T>> T applyDefaultValues(T toBuildable, Consumer<B> defaultApplier) {
        B builder = toBuildable.toBuilder();
        defaultApplier.accept(builder);
        return (T)((ToCopyableBuilder)builder.build());
    }
}

