/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.AmazonWebServiceResponse;
import software.amazon.awssdk.LegacyClientConfiguration;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.RequestConfig;
import software.amazon.awssdk.RequestExecutionContext;
import software.amazon.awssdk.Response;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.annotation.SdkTestInternalApi;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.http.ExecutionContext;
import software.amazon.awssdk.http.HttpClientDependencies;
import software.amazon.awssdk.http.HttpResponse;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullRequestAdapter;
import software.amazon.awssdk.http.StreamManagingStage;
import software.amazon.awssdk.http.UnreliableTestConfig;
import software.amazon.awssdk.http.exception.SdkInterruptedException;
import software.amazon.awssdk.http.pipeline.RequestPipelineBuilder;
import software.amazon.awssdk.http.pipeline.stages.AfterCallbackStage;
import software.amazon.awssdk.http.pipeline.stages.ApplyTransactionIdStage;
import software.amazon.awssdk.http.pipeline.stages.ApplyUserAgentStage;
import software.amazon.awssdk.http.pipeline.stages.AttachRequestConfigStage;
import software.amazon.awssdk.http.pipeline.stages.BeforeRequestHandlersStage;
import software.amazon.awssdk.http.pipeline.stages.BeforeUnmarshallingCallbackStage;
import software.amazon.awssdk.http.pipeline.stages.ClientExecutionTimedStage;
import software.amazon.awssdk.http.pipeline.stages.ExceptionReportingStage;
import software.amazon.awssdk.http.pipeline.stages.HandleResponseStage;
import software.amazon.awssdk.http.pipeline.stages.HttpResponseAdaptingStage;
import software.amazon.awssdk.http.pipeline.stages.InstrumentHttpResponseContentStage;
import software.amazon.awssdk.http.pipeline.stages.MakeHttpRequestStage;
import software.amazon.awssdk.http.pipeline.stages.MakeRequestImmutable;
import software.amazon.awssdk.http.pipeline.stages.MakeRequestMutable;
import software.amazon.awssdk.http.pipeline.stages.MergeCustomHeadersStage;
import software.amazon.awssdk.http.pipeline.stages.MergeCustomQueryParamsStage;
import software.amazon.awssdk.http.pipeline.stages.MoveParametersToBodyStage;
import software.amazon.awssdk.http.pipeline.stages.ReportRequestContentLengthStage;
import software.amazon.awssdk.http.pipeline.stages.RetryableStage;
import software.amazon.awssdk.http.pipeline.stages.SigningStage;
import software.amazon.awssdk.http.pipeline.stages.TimerExceptionHandlingStage;
import software.amazon.awssdk.http.pipeline.stages.UnwrapResponseContainer;
import software.amazon.awssdk.internal.AmazonWebServiceRequestAdapter;
import software.amazon.awssdk.internal.http.response.AwsErrorResponseHandler;
import software.amazon.awssdk.internal.http.response.AwsResponseHandlerAdapter;
import software.amazon.awssdk.internal.http.timers.client.ClientExecutionTimer;
import software.amazon.awssdk.metrics.RequestMetricCollector;
import software.amazon.awssdk.retry.RetryPolicyAdapter;
import software.amazon.awssdk.retry.v2.RetryPolicy;
import software.amazon.awssdk.util.CapacityManager;
import software.amazon.awssdk.utils.Validate;

@ThreadSafe
@SdkProtectedApi
public class AmazonHttpClient
implements AutoCloseable {
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String HEADER_SDK_TRANSACTION_ID = "amz-sdk-invocation-id";
    @SdkInternalApi
    public static final Log REQUEST_LOG = LogFactory.getLog("software.amazon.awssdk.request");
    public static final int THROTTLED_RETRY_COST = 5;
    static UnreliableTestConfig unreliableTestConfig;
    static final int THROTTLED_RETRIES = 100;
    private final RequestMetricCollector requestMetricCollector;
    private final HttpClientDependencies httpClientDependencies;

    private AmazonHttpClient(HttpClientDependencies httpClientDependencies, RequestMetricCollector requestMetricCollector) {
        this.httpClientDependencies = Validate.paramNotNull(httpClientDependencies, "HttpClientDependencies");
        this.requestMetricCollector = requestMetricCollector;
    }

    public static Builder builder() {
        return new Builder();
    }

    static void configUnreliableTestConditions(UnreliableTestConfig config) {
        unreliableTestConfig = config;
    }

    @Override
    public void close() throws Exception {
        this.httpClientDependencies.close();
    }

    @SdkTestInternalApi
    public ClientExecutionTimer getClientExecutionTimer() {
        return this.httpClientDependencies.clientExecutionTimer();
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    public static void checkInterrupted() throws InterruptedException {
        AmazonHttpClient.checkInterrupted(null);
    }

    public static void checkInterrupted(Response<?> response) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new SdkInterruptedException(response);
        }
    }

    @Deprecated
    public <T> T execute(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpResponseHandler<AmazonServiceException> errorResponseHandler, ExecutionContext executionContext) {
        AwsResponseHandlerAdapter<T> adaptedRespHandler = new AwsResponseHandlerAdapter<T>(this.getNonNullResponseHandler(responseHandler), executionContext.getAwsRequestMetrics());
        return this.requestExecutionBuilder().request(request).requestConfig(new AmazonWebServiceRequestAdapter(request.getOriginalRequest())).errorResponseHandler(new AwsErrorResponseHandler(errorResponseHandler, executionContext.getAwsRequestMetrics())).executionContext(executionContext).execute(adaptedRespHandler);
    }

    private <T> HttpResponseHandler<T> getNonNullResponseHandler(HttpResponseHandler<T> responseHandler) {
        if (responseHandler != null) {
            return responseHandler;
        }
        return new NoOpResponseHandler();
    }

    public RequestExecutionBuilder requestExecutionBuilder() {
        return new RequestExecutionBuilderImpl();
    }

    private class RequestExecutionBuilderImpl
    implements RequestExecutionBuilder {
        private SdkHttpFullRequest request;
        private RequestConfig requestConfig;
        private HttpResponseHandler<? extends SdkBaseException> errorResponseHandler;
        private ExecutionContext executionContext = new ExecutionContext();

        private RequestExecutionBuilderImpl() {
        }

        @Override
        public RequestExecutionBuilder request(Request<?> request) {
            this.request = SdkHttpFullRequestAdapter.toHttpFullRequest(request);
            return this;
        }

        @Override
        public RequestExecutionBuilder request(SdkHttpFullRequest request) {
            this.request = request;
            return this;
        }

        @Override
        public RequestExecutionBuilder errorResponseHandler(HttpResponseHandler<? extends SdkBaseException> errorResponseHandler) {
            this.errorResponseHandler = errorResponseHandler;
            return this;
        }

        @Override
        public RequestExecutionBuilder executionContext(ExecutionContext executionContext) {
            this.executionContext = executionContext;
            return this;
        }

        @Override
        public RequestExecutionBuilder requestConfig(RequestConfig requestConfig) {
            this.requestConfig = requestConfig;
            return this;
        }

        @Override
        public <OutputT> OutputT execute(HttpResponseHandler<OutputT> responseHandler) {
            try {
                return (OutputT)RequestPipelineBuilder.first(AttachRequestConfigStage::new).then(BeforeRequestHandlersStage::new).then(MakeRequestMutable::new).then(ApplyTransactionIdStage::new).then(ApplyUserAgentStage::new).then(MergeCustomHeadersStage::new).then(MergeCustomQueryParamsStage::new).then(MoveParametersToBodyStage::new).then(MakeRequestImmutable::new).then(ReportRequestContentLengthStage::new).then(RequestPipelineBuilder.first(SigningStage::new).then(MakeHttpRequestStage::new).then(HttpResponseAdaptingStage::new).then(InstrumentHttpResponseContentStage::new).then(BeforeUnmarshallingCallbackStage::new).then(() -> new HandleResponseStage(AmazonHttpClient.this.getNonNullResponseHandler(responseHandler), AmazonHttpClient.this.getNonNullResponseHandler(this.errorResponseHandler))).wrap(ExceptionReportingStage::new).wrap(TimerExceptionHandlingStage::new).wrap(RetryableStage::new)::build).wrap(StreamManagingStage::new).wrap(AfterCallbackStage::new).wrap(ClientExecutionTimedStage::new).then(() -> new UnwrapResponseContainer()).build(AmazonHttpClient.this.httpClientDependencies).execute(this.request, this.createRequestExecutionDependencies());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SdkClientException(e);
            }
        }

        @Override
        public void execute() {
            this.execute(null);
        }

        private RequestExecutionContext createRequestExecutionDependencies() {
            return RequestExecutionContext.builder().requestConfig(this.requestConfig == null ? RequestConfig.NO_OP : this.requestConfig).executionContext(this.executionContext).build();
        }
    }

    private static class NoOpResponseHandler<T>
    implements HttpResponseHandler<T> {
        private NoOpResponseHandler() {
        }

        @Override
        public T handle(HttpResponse response) throws Exception {
            return null;
        }

        @Override
        public boolean needsConnectionLeftOpen() {
            return false;
        }
    }

    public static class Builder {
        private LegacyClientConfiguration clientConfig;
        private RetryPolicy retryPolicy;
        private RequestMetricCollector requestMetricCollector;
        private boolean calculateCrc32FromCompressedData;
        private SdkHttpClient sdkHttpClient;

        private Builder() {
        }

        public Builder clientConfiguration(LegacyClientConfiguration clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        public Builder retryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public Builder requestMetricCollector(RequestMetricCollector requestMetricCollector) {
            this.requestMetricCollector = requestMetricCollector;
            return this;
        }

        public Builder calculateCrc32FromCompressedData(boolean calculateCrc32FromCompressedData) {
            this.calculateCrc32FromCompressedData = calculateCrc32FromCompressedData;
            return this;
        }

        public Builder sdkHttpClient(SdkHttpClient sdkHttpClient) {
            this.sdkHttpClient = sdkHttpClient;
            return this;
        }

        public AmazonHttpClient build() {
            return new AmazonHttpClient(HttpClientDependencies.builder().clientExecutionTimer(new ClientExecutionTimer()).config(this.clientConfig).retryCapacity(this.createCapacityManager()).retryPolicy(this.resolveRetryPolicy()).calculateCrc32FromCompressedData(this.calculateCrc32FromCompressedData).sdkHttpClient(this.sdkHttpClient).build(), this.requestMetricCollector);
        }

        private CapacityManager createCapacityManager() {
            int throttledRetryMaxCapacity = this.clientConfig.useThrottledRetries() ? 500 : -1;
            return new CapacityManager(throttledRetryMaxCapacity);
        }

        private RetryPolicy resolveRetryPolicy() {
            return this.retryPolicy == null ? new RetryPolicyAdapter(this.clientConfig.getRetryPolicy(), this.clientConfig) : this.retryPolicy;
        }
    }

    public static interface RequestExecutionBuilder {
        @Deprecated
        public RequestExecutionBuilder request(Request<?> var1);

        public RequestExecutionBuilder request(SdkHttpFullRequest var1);

        public RequestExecutionBuilder errorResponseHandler(HttpResponseHandler<? extends SdkBaseException> var1);

        public RequestExecutionBuilder executionContext(ExecutionContext var1);

        public RequestExecutionBuilder requestConfig(RequestConfig var1);

        public <OutputT> OutputT execute(HttpResponseHandler<OutputT> var1);

        public void execute();
    }
}

