/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.http.HandlerContextKey;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
public class DefaultSdkHttpFullRequest
implements SdkHttpFullRequest {
    private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private final String resourcePath;
    private final Map<String, List<String>> queryParameters = new LinkedHashMap<String, List<String>>();
    private final URI endpoint;
    private final SdkHttpMethod httpMethod;
    private final InputStream content;
    private final AttributeMap handlerContextKeys;

    private DefaultSdkHttpFullRequest(Builder builder) {
        this.headers.putAll(builder.headers);
        this.queryParameters.putAll(builder.queryParameters);
        this.resourcePath = builder.resourcePath;
        this.endpoint = builder.endpoint;
        this.httpMethod = builder.httpMethod;
        this.content = builder.content;
        this.handlerContextKeys = builder.handlerContextKeys.build();
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return CollectionUtils.deepUnmodifiableMap(this.headers);
    }

    @Override
    public Collection<String> getValuesForHeader(String header) {
        List<String> values = this.headers.get(header);
        return values != null ? Collections.unmodifiableList(values) : Collections.emptyList();
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public Map<String, List<String>> getParameters() {
        return CollectionUtils.deepUnmodifiableLinkedMap(this.queryParameters);
    }

    @Override
    public URI getEndpoint() {
        return this.endpoint;
    }

    @Override
    public SdkHttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public InputStream getContent() {
        return this.content;
    }

    @Override
    public <T> T handlerContext(HandlerContextKey<T> key) {
        return this.handlerContextKeys.get(key);
    }

    @Override
    public Builder toBuilder() {
        return ((Builder)((Builder)new Builder(this.handlerContextKeys.toBuilder()).headers((Map)this.headers)).resourcePath(this.resourcePath).httpMethod(this.httpMethod).endpoint(this.endpoint).queryParameters((Map)this.queryParameters)).content(this.content);
    }

    public static Builder builder() {
        return new Builder(AttributeMap.builder());
    }

    public static final class Builder
    implements SdkHttpFullRequest.Builder {
        private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private String resourcePath;
        @ReviewBeforeRelease(value="Do we need linked hash map here?")
        private Map<String, List<String>> queryParameters = new LinkedHashMap<String, List<String>>();
        private URI endpoint;
        private SdkHttpMethod httpMethod;
        private InputStream content;
        private final AttributeMap.Builder handlerContextKeys;

        private Builder(AttributeMap.Builder handlerContextKeys) {
            this.handlerContextKeys = handlerContextKeys;
        }

        @Override
        public Builder header(String key, List<String> values) {
            this.headers.put(key, new ArrayList<String>(values));
            return this;
        }

        @Override
        public Builder headers(Map<String, List<String>> headers) {
            headers.forEach((k, v) -> {
                List cfr_ignored_0 = this.headers.put((String)k, new ArrayList(v));
            });
            return this;
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            return CollectionUtils.deepUnmodifiableMap(this.headers);
        }

        @Override
        public Builder resourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
            return this;
        }

        @Override
        public String getResourcePath() {
            return this.resourcePath;
        }

        @Override
        public Builder queryParameter(String paramName, List<String> paramValues) {
            this.queryParameters.put(paramName, new ArrayList<String>(paramValues));
            return this;
        }

        @Override
        public Builder queryParameters(Map<String, List<String>> queryParameters) {
            queryParameters.forEach((k, v) -> {
                List cfr_ignored_0 = this.queryParameters.put((String)k, new ArrayList(v));
            });
            return this;
        }

        @Override
        public Builder removeQueryParameter(String paramName) {
            this.queryParameters.remove(paramName);
            return this;
        }

        @Override
        public Builder clearQueryParameters() {
            this.queryParameters.clear();
            return this;
        }

        @Override
        public Map<String, List<String>> getParameters() {
            return CollectionUtils.deepUnmodifiableLinkedMap(this.queryParameters);
        }

        @Override
        public Builder endpoint(URI endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public URI getEndpoint() {
            return this.endpoint;
        }

        @Override
        public Builder httpMethod(SdkHttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        @Override
        public SdkHttpMethod getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public Builder content(InputStream content) {
            this.content = content;
            return this;
        }

        @Override
        public InputStream getContent() {
            return this.content;
        }

        @Override
        public <T> Builder handlerContext(HandlerContextKey<T> key, T value) {
            this.handlerContextKeys.put(key, value);
            return this;
        }

        @Override
        public <T> T handlerContext(HandlerContextKey<T> key) {
            return this.handlerContextKeys.get(key);
        }

        @Override
        public DefaultSdkHttpFullRequest build() {
            return new DefaultSdkHttpFullRequest(this);
        }
    }
}

