/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.io.InputStream;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import software.amazon.awssdk.http.HttpResponse;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.util.Crc32ChecksumValidatingInputStream;
import software.amazon.awssdk.utils.FunctionalUtils;

public class SdkHttpResponseAdapter {
    public static HttpResponse adapt(boolean calculateCrc32FromCompressedData, SdkHttpFullRequest request, SdkHttpFullResponse awsHttpResponse) {
        HttpResponse httpResponse = new HttpResponse(request, awsHttpResponse.getContent());
        httpResponse.setStatusCode(awsHttpResponse.getStatusCode());
        httpResponse.setStatusText(awsHttpResponse.getStatusText());
        awsHttpResponse.getHeaders().forEach((k, v) -> httpResponse.addHeader((String)k, (String)v.get(0)));
        httpResponse.setContent(SdkHttpResponseAdapter.getContent(calculateCrc32FromCompressedData, awsHttpResponse, httpResponse));
        return httpResponse;
    }

    private static InputStream crc32Validating(InputStream source, long expectedChecksum) {
        return new Crc32ChecksumValidatingInputStream(source, expectedChecksum);
    }

    private static InputStream getContent(boolean calculateCrc32FromCompressedData, SdkHttpFullResponse awsHttpResponse, HttpResponse httpResponse) {
        Optional<Long> crc32Checksum = SdkHttpResponseAdapter.getCrc32Checksum(httpResponse);
        if (SdkHttpResponseAdapter.shouldDecompress(httpResponse)) {
            if (calculateCrc32FromCompressedData && crc32Checksum.isPresent()) {
                return SdkHttpResponseAdapter.decompressing(SdkHttpResponseAdapter.crc32Validating(awsHttpResponse.getContent(), crc32Checksum.get()));
            }
            if (crc32Checksum.isPresent()) {
                return SdkHttpResponseAdapter.crc32Validating(SdkHttpResponseAdapter.decompressing(awsHttpResponse.getContent()), crc32Checksum.get());
            }
            return SdkHttpResponseAdapter.decompressing(awsHttpResponse.getContent());
        }
        if (crc32Checksum.isPresent()) {
            return SdkHttpResponseAdapter.crc32Validating(awsHttpResponse.getContent(), crc32Checksum.get());
        }
        return awsHttpResponse.getContent();
    }

    private static Optional<Long> getCrc32Checksum(HttpResponse httpResponse) {
        return Optional.ofNullable(httpResponse.getHeader("x-amz-crc32")).map(Long::valueOf);
    }

    private static boolean shouldDecompress(HttpResponse httpResponse) {
        return "gzip".equals(httpResponse.getHeader("Content-Encoding"));
    }

    private static InputStream decompressing(InputStream source) {
        return FunctionalUtils.invokeSafely(() -> new GZIPInputStream(source));
    }
}

