/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ApacheSdkHttpClientFactory;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.http.apache.internal.ApacheHttpRequestConfig;
import software.amazon.awssdk.http.apache.internal.Defaults;
import software.amazon.awssdk.http.apache.internal.SdkHttpRequestExecutor;
import software.amazon.awssdk.http.apache.internal.SdkProxyRoutePlanner;
import software.amazon.awssdk.http.apache.internal.conn.ClientConnectionManagerFactory;
import software.amazon.awssdk.http.apache.internal.conn.SdkConnectionKeepAliveStrategy;
import software.amazon.awssdk.http.apache.internal.impl.ApacheConnectionManagerFactory;
import software.amazon.awssdk.http.apache.internal.impl.ApacheSdkClient;
import software.amazon.awssdk.http.apache.internal.impl.ConnectionManagerAwareHttpClient;
import software.amazon.awssdk.http.apache.internal.utils.ApacheUtils;
import software.amazon.awssdk.utils.AttributeMap;

@SdkInternalApi
class ApacheHttpClientFactory {
    private static final Log LOG = LogFactory.getLog(ApacheHttpClientFactory.class);
    private final ApacheConnectionManagerFactory cmFactory = new ApacheConnectionManagerFactory();

    ApacheHttpClientFactory() {
    }

    public SdkHttpClient create(ApacheSdkHttpClientFactory configuration, AttributeMap resolvedOptions, ApacheHttpRequestConfig requestConfig) {
        return new ApacheHttpClient(this.createClient(configuration, resolvedOptions), requestConfig, resolvedOptions);
    }

    private ConnectionManagerAwareHttpClient createClient(ApacheSdkHttpClientFactory configuration, AttributeMap standardOptions) {
        HttpClientBuilder builder = HttpClients.custom();
        HttpClientConnectionManager cm = this.cmFactory.create(configuration, standardOptions);
        builder.setRequestExecutor(new SdkHttpRequestExecutor()).disableContentCompression().setKeepAliveStrategy(this.buildKeepAliveStrategy(configuration)).disableRedirectHandling().disableAutomaticRetries().setConnectionManager(ClientConnectionManagerFactory.wrap(cm));
        this.addProxyConfig(builder, configuration.proxyConfiguration());
        return new ApacheSdkClient(builder.build(), cm);
    }

    private void addProxyConfig(HttpClientBuilder builder, ProxyConfiguration proxyConfiguration) {
        if (this.isProxyEnabled(proxyConfiguration)) {
            LOG.info("Configuring Proxy. Proxy Host: " + proxyConfiguration.endpoint());
            builder.setRoutePlanner(new SdkProxyRoutePlanner(proxyConfiguration.endpoint().getHost(), proxyConfiguration.endpoint().getPort(), proxyConfiguration.nonProxyHosts()));
            if (this.isAuthenticatedProxy(proxyConfiguration)) {
                builder.setDefaultCredentialsProvider(ApacheUtils.newProxyCredentialsProvider(proxyConfiguration));
            }
        }
    }

    private ConnectionKeepAliveStrategy buildKeepAliveStrategy(ApacheSdkHttpClientFactory configuration) {
        long maxIdle = configuration.connectionMaxIdleTime().orElse(Defaults.MAX_IDLE_CONNECTION_TIME).toMillis();
        return maxIdle > 0L ? new SdkConnectionKeepAliveStrategy(maxIdle) : null;
    }

    private boolean isAuthenticatedProxy(ProxyConfiguration proxyConfiguration) {
        return proxyConfiguration.username() != null && proxyConfiguration.password() != null;
    }

    private boolean isProxyEnabled(ProxyConfiguration proxyConfiguration) {
        return proxyConfiguration.endpoint() != null && proxyConfiguration.endpoint().getHost() != null && proxyConfiguration.endpoint().getPort() > 0;
    }
}

