/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache;

import java.net.InetAddress;
import java.time.Duration;
import java.util.Optional;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpClientFactory;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.apache.ApacheHttpClientFactory;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.http.apache.internal.ApacheHttpRequestConfig;
import software.amazon.awssdk.http.apache.internal.Defaults;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApacheSdkHttpClientFactory
implements SdkHttpClientFactory,
ToCopyableBuilder<Builder, ApacheSdkHttpClientFactory> {
    private final AttributeMap standardOptions;
    private final ProxyConfiguration proxyConfiguration;
    private final Optional<InetAddress> localAddress;
    private final Optional<Boolean> expectContinueEnabled;
    private final Optional<Duration> connectionPoolTtl;
    private final Optional<Duration> maxIdleConnectionTimeout;

    private ApacheSdkHttpClientFactory(DefaultBuilder builder) {
        this.standardOptions = builder.standardOptions.build();
        this.proxyConfiguration = builder.proxyConfiguration;
        this.localAddress = Optional.ofNullable(builder.localAddress);
        this.expectContinueEnabled = Optional.ofNullable(builder.expectContinueEnabled);
        this.connectionPoolTtl = Optional.ofNullable(builder.connectionTimeToLive);
        this.maxIdleConnectionTimeout = Optional.ofNullable(builder.connectionMaxIdleTime);
    }

    public ProxyConfiguration proxyConfiguration() {
        return this.proxyConfiguration;
    }

    public Optional<InetAddress> localAddress() {
        return this.localAddress;
    }

    public Optional<Boolean> expectContinueEnabled() {
        return this.expectContinueEnabled;
    }

    public Optional<Duration> connectionTimeToLive() {
        return this.connectionPoolTtl;
    }

    public Optional<Duration> connectionMaxIdleTime() {
        return this.maxIdleConnectionTimeout;
    }

    public SdkHttpClient createHttpClient() {
        return this.createHttpClientWithDefaults(AttributeMap.empty());
    }

    @Override
    public SdkHttpClient createHttpClientWithDefaults(AttributeMap serviceDefaults) {
        AttributeMap resolvedOptions = this.standardOptions.merge(serviceDefaults).merge(SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS);
        return new ApacheHttpClientFactory().create(this, resolvedOptions, this.createRequestConfig(resolvedOptions));
    }

    private ApacheHttpRequestConfig createRequestConfig(AttributeMap resolvedOptions) {
        return ApacheHttpRequestConfig.builder().socketTimeout(resolvedOptions.get(SdkHttpConfigurationOption.SOCKET_TIMEOUT)).connectionTimeout(resolvedOptions.get(SdkHttpConfigurationOption.CONNECTION_TIMEOUT)).proxyConfiguration(this.proxyConfiguration).localAddress(this.localAddress.orElse(null)).expectContinueEnabled(this.expectContinueEnabled.orElse(Defaults.EXPECT_CONTINUE_ENABLED)).build();
    }

    public static Builder builder() {
        return new DefaultBuilder(AttributeMap.builder());
    }

    @Override
    public Builder toBuilder() {
        return new DefaultBuilder(this.standardOptions.toBuilder()).proxyConfiguration(this.proxyConfiguration).localAddress(this.localAddress.orElse(null)).expectContinueEnabled(this.expectContinueEnabled.orElse(null)).connectionTimeToLive(this.connectionPoolTtl.orElse(null)).connectionMaxIdleTime(this.maxIdleConnectionTimeout.orElse(null));
    }

    @ReviewBeforeRelease(value="Review the options we expose and revisit organization of options.")
    private static final class DefaultBuilder
    implements Builder {
        private final AttributeMap.Builder standardOptions;
        private ProxyConfiguration proxyConfiguration = (ProxyConfiguration)ProxyConfiguration.builder().build();
        private InetAddress localAddress;
        private Boolean expectContinueEnabled;
        private Duration connectionTimeToLive;
        private Duration connectionMaxIdleTime;

        private DefaultBuilder(AttributeMap.Builder standardOptions) {
            this.standardOptions = standardOptions;
        }

        @Override
        public Builder socketTimeout(Duration socketTimeout) {
            this.standardOptions.put(SdkHttpConfigurationOption.SOCKET_TIMEOUT, socketTimeout);
            return this;
        }

        public void setSocketTimeout(Duration socketTimeout) {
            this.socketTimeout(socketTimeout);
        }

        @Override
        public Builder connectionTimeout(Duration connectionTimeout) {
            this.standardOptions.put(SdkHttpConfigurationOption.CONNECTION_TIMEOUT, connectionTimeout);
            return this;
        }

        public void setConnectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout(connectionTimeout);
        }

        @Override
        public Builder maxConnections(Integer maxConnections) {
            this.standardOptions.put(SdkHttpConfigurationOption.MAX_CONNECTIONS, maxConnections);
            return this;
        }

        public void setMaxConnections(Integer maxConnections) {
            this.maxConnections(maxConnections);
        }

        @Override
        public Builder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        public void setProxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration(proxyConfiguration);
        }

        @Override
        public Builder localAddress(InetAddress localAddress) {
            this.localAddress = localAddress;
            return this;
        }

        public void setLocalAddress(InetAddress localAddress) {
            this.localAddress(localAddress);
        }

        @Override
        public Builder expectContinueEnabled(Boolean expectContinueEnabled) {
            this.expectContinueEnabled = expectContinueEnabled;
            return this;
        }

        public void setExpectContinueEnabled(Boolean useExpectContinue) {
            this.expectContinueEnabled = useExpectContinue;
        }

        @Override
        public Builder connectionTimeToLive(Duration connectionTimeToLive) {
            this.connectionTimeToLive = connectionTimeToLive;
            return this;
        }

        public void setConnectionTimeToLive(Duration connectionTimeToLive) {
            this.connectionTimeToLive(connectionTimeToLive);
        }

        @Override
        public Builder connectionMaxIdleTime(Duration maxIdleConnectionTimeout) {
            this.connectionMaxIdleTime = maxIdleConnectionTimeout;
            return this;
        }

        public void setConnectionMaxIdleTime(Duration connectionMaxIdleTime) {
            this.connectionMaxIdleTime(connectionMaxIdleTime);
        }

        @Override
        public ApacheSdkHttpClientFactory build() {
            return new ApacheSdkHttpClientFactory(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApacheSdkHttpClientFactory> {
        public Builder socketTimeout(Duration var1);

        public Builder connectionTimeout(Duration var1);

        public Builder maxConnections(Integer var1);

        public Builder proxyConfiguration(ProxyConfiguration var1);

        public Builder localAddress(InetAddress var1);

        public Builder expectContinueEnabled(Boolean var1);

        public Builder connectionTimeToLive(Duration var1);

        public Builder connectionMaxIdleTime(Duration var1);
    }
}

