/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.InputStreamEntity;
import software.amazon.awssdk.http.SdkHttpFullRequest;

public class RepeatableInputStreamRequestEntity
extends BasicHttpEntity {
    private static final Log LOG = LogFactory.getLog(RepeatableInputStreamRequestEntity.class);
    private boolean firstAttempt = true;
    private InputStreamEntity inputStreamRequestEntity;
    private InputStream content;
    private IOException originalException;

    public RepeatableInputStreamRequestEntity(SdkHttpFullRequest request) {
        this.setChunked(false);
        long contentLength = request.getFirstHeaderValue("Content-Length").map(this::parseContentLength).orElse(-1L);
        this.content = this.getContent(request);
        this.inputStreamRequestEntity = new InputStreamEntity(this.content, contentLength);
        this.setContent(this.content);
        this.setContentLength(contentLength);
        request.getFirstHeaderValue("Content-Type").ifPresent(contentType -> {
            this.inputStreamRequestEntity.setContentType((String)contentType);
            this.setContentType((String)contentType);
        });
    }

    private long parseContentLength(String contentLength) {
        try {
            return Long.parseLong(contentLength);
        }
        catch (NumberFormatException nfe) {
            LOG.warn("Unable to parse content length from request. Buffering contents in memory.");
            return -1L;
        }
    }

    private InputStream getContent(SdkHttpFullRequest request) {
        return request.getContent() == null ? new ByteArrayInputStream(new byte[0]) : request.getContent();
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public boolean isRepeatable() {
        return this.content.markSupported() || this.inputStreamRequestEntity.isRepeatable();
    }

    @Override
    public void writeTo(OutputStream output) throws IOException {
        try {
            if (!this.firstAttempt && this.isRepeatable()) {
                this.content.reset();
            }
            this.firstAttempt = false;
            this.inputStreamRequestEntity.writeTo(output);
        }
        catch (IOException ioe) {
            if (this.originalException == null) {
                this.originalException = ioe;
            }
            throw this.originalException;
        }
    }
}

