/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache.internal;

import java.io.IOException;
import java.net.Socket;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import software.amazon.awssdk.http.apache.internal.net.SdkMetricsSocket;
import software.amazon.awssdk.http.apache.internal.net.SdkSslMetricsSocket;
import software.amazon.awssdk.metrics.spi.AwsRequestMetrics;

public class SdkHttpRequestExecutor
extends HttpRequestExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpResponse doSendRequest(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        AwsRequestMetrics awsRequestMetrics = (AwsRequestMetrics)context.getAttribute(AwsRequestMetrics.class.getSimpleName());
        if (awsRequestMetrics == null) {
            return super.doSendRequest(request, conn, context);
        }
        if (conn instanceof ManagedHttpClientConnection) {
            ManagedHttpClientConnection managedConn = (ManagedHttpClientConnection)conn;
            Socket sock = managedConn.getSocket();
            if (sock instanceof SdkMetricsSocket) {
                SdkMetricsSocket sdkMetricsSocket = (SdkMetricsSocket)sock;
                sdkMetricsSocket.setMetrics(awsRequestMetrics);
            } else if (sock instanceof SdkSslMetricsSocket) {
                SdkSslMetricsSocket sdkSslMetricsSocket = (SdkSslMetricsSocket)sock;
                sdkSslMetricsSocket.setMetrics(awsRequestMetrics);
            }
        }
        awsRequestMetrics.startEvent(AwsRequestMetrics.Field.HttpClientSendRequestTime);
        try {
            HttpResponse httpResponse = super.doSendRequest(request, conn, context);
            return httpResponse;
        }
        finally {
            awsRequestMetrics.endEvent(AwsRequestMetrics.Field.HttpClientSendRequestTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpResponse doReceiveResponse(HttpRequest request, HttpClientConnection conn, HttpContext context) throws HttpException, IOException {
        AwsRequestMetrics awsRequestMetrics = (AwsRequestMetrics)context.getAttribute(AwsRequestMetrics.class.getSimpleName());
        if (awsRequestMetrics == null) {
            return super.doReceiveResponse(request, conn, context);
        }
        awsRequestMetrics.startEvent(AwsRequestMetrics.Field.HttpClientReceiveResponseTime);
        try {
            HttpResponse httpResponse = super.doReceiveResponse(request, conn, context);
            return httpResponse;
        }
        finally {
            awsRequestMetrics.endEvent(AwsRequestMetrics.Field.HttpClientReceiveResponseTime);
        }
    }
}

