/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache.internal.conn;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import software.amazon.awssdk.http.apache.internal.conn.TlsProtocol;

public class SdkTlsSocketFactory
extends SSLConnectionSocketFactory {
    private static final Log LOG = LogFactory.getLog(SdkTlsSocketFactory.class);
    private final SSLContext sslContext;

    public SdkTlsSocketFactory(SSLContext sslContext, HostnameVerifier hostnameVerifier) {
        super(sslContext, hostnameVerifier);
        if (sslContext == null) {
            throw new IllegalArgumentException("sslContext must not be null. Use SSLContext.getDefault() if you are unsure.");
        }
        this.sslContext = sslContext;
    }

    @Override
    protected final void prepareSocket(SSLSocket socket) {
        Object[] supported = socket.getSupportedProtocols();
        Object[] enabled = socket.getEnabledProtocols();
        if (LOG.isDebugEnabled()) {
            LOG.debug("socket.getSupportedProtocols(): " + Arrays.toString(supported) + ", socket.getEnabledProtocols(): " + Arrays.toString(enabled));
        }
        ArrayList<Object> target = new ArrayList<Object>();
        if (supported != null) {
            TlsProtocol[] tlsProtocolArray = TlsProtocol.values();
            for (int i = 0; i < tlsProtocolArray.length; ++i) {
                String pname = tlsProtocolArray[i].getProtocolName();
                if (!this.existsIn(pname, (String[])supported)) continue;
                target.add(pname);
            }
        }
        if (enabled != null) {
            for (Object object : enabled) {
                if (target.contains(object)) continue;
                target.add(object);
            }
        }
        if (target.size() > 0) {
            Object[] objectArray = target.toArray(new String[target.size()]);
            socket.setEnabledProtocols((String[])objectArray);
            if (LOG.isDebugEnabled()) {
                LOG.debug("TLS protocol enabled for SSL handshake: " + Arrays.toString(objectArray));
            }
        }
    }

    private boolean existsIn(String element, String[] a2) {
        for (String s : a2) {
            if (!element.equals(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("connecting to " + remoteAddress.getAddress() + ":" + remoteAddress.getPort());
        }
        return super.connectSocket(connectTimeout, socket, host, remoteAddress, localAddress, context);
    }
}

