/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache.internal.impl;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.apache.ApacheSdkHttpClientFactory;
import software.amazon.awssdk.http.apache.internal.Defaults;
import software.amazon.awssdk.http.apache.internal.conn.SdkTlsSocketFactory;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.NumericUtils;

public class ApacheConnectionManagerFactory {
    public HttpClientConnectionManager create(ApacheSdkHttpClientFactory configuration, AttributeMap standardOptions) {
        ConnectionSocketFactory sslsf = this.getPreferredSocketFactory(standardOptions);
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(this.createSocketFactoryRegistry(sslsf), null, DefaultSchemePortResolver.INSTANCE, null, configuration.connectionTimeToLive().orElse(Defaults.CONNECTION_POOL_TTL).toMillis(), TimeUnit.MILLISECONDS);
        cm.setDefaultMaxPerRoute(standardOptions.get(SdkHttpConfigurationOption.MAX_CONNECTIONS));
        cm.setMaxTotal(standardOptions.get(SdkHttpConfigurationOption.MAX_CONNECTIONS));
        cm.setDefaultSocketConfig(this.buildSocketConfig(standardOptions));
        return cm;
    }

    private ConnectionSocketFactory getPreferredSocketFactory(AttributeMap standardOptions) {
        return new SdkTlsSocketFactory(ApacheConnectionManagerFactory.getPreferredSslContext(), this.getHostNameVerifier(standardOptions));
    }

    private static SSLContext getPreferredSslContext() {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, null, null);
            return sslcontext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            throw new SSLInitializationException(ex.getMessage(), ex);
        }
    }

    private SocketConfig buildSocketConfig(AttributeMap standardOptions) {
        return SocketConfig.custom().setSoKeepAlive(false).setSoTimeout(NumericUtils.saturatedCast(standardOptions.get(SdkHttpConfigurationOption.SOCKET_TIMEOUT).toMillis())).setTcpNoDelay(true).build();
    }

    @ReviewBeforeRelease(value="Need to have a way to communicate with HTTP impl supports disabling of stricthostname verification. If it doesn't we either need to fail in S3 or switch to path styleaddressing.")
    private HostnameVerifier getHostNameVerifier(AttributeMap standardOptions) {
        return standardOptions.get(SdkHttpConfigurationOption.USE_STRICT_HOSTNAME_VERIFICATION) != false ? SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER : SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
    }

    private Registry<ConnectionSocketFactory> createSocketFactoryRegistry(ConnectionSocketFactory sslSocketFactory) {
        return RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)sslSocketFactory).build();
    }
}

