/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache.internal.impl;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.apache.internal.ApacheHttpRequestConfig;
import software.amazon.awssdk.http.apache.internal.RepeatableInputStreamRequestEntity;
import software.amazon.awssdk.http.apache.internal.impl.SdkHttpUtils;
import software.amazon.awssdk.http.apache.internal.utils.ApacheUtils;
import software.amazon.awssdk.utils.NumericUtils;
import software.amazon.awssdk.utils.StringUtils;

public class ApacheHttpRequestFactory {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final List<String> IGNORE_HEADERS = Arrays.asList("Content-Length", "Host");

    public HttpRequestBase create(SdkHttpFullRequest request, ApacheHttpRequestConfig requestConfig) {
        URI endpoint = request.getEndpoint();
        String uri = SdkHttpUtils.appendUri(endpoint.toString(), request.getResourcePath(), true);
        String encodedParams = SdkHttpUtils.encodeParameters(request);
        if (StringUtils.isNotBlank(encodedParams)) {
            uri = uri + "?" + encodedParams;
        }
        HttpRequestBase base = this.createApacheRequest(request, uri, encodedParams);
        this.addHeadersToRequest(base, request);
        this.addRequestConfig(base, request, requestConfig);
        return base;
    }

    private void addRequestConfig(HttpRequestBase base, SdkHttpFullRequest request, ApacheHttpRequestConfig requestConfig) {
        int connectTimeout = NumericUtils.saturatedCast(requestConfig.connectionTimeout().toMillis());
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectionRequestTimeout(connectTimeout).setConnectTimeout(connectTimeout).setSocketTimeout(NumericUtils.saturatedCast(requestConfig.socketTimeout().toMillis())).setLocalAddress(requestConfig.localAddress());
        if (SdkHttpMethod.PUT == request.getHttpMethod() && requestConfig.expectContinueEnabled()) {
            requestConfigBuilder.setExpectContinueEnabled(true);
        }
        base.setConfig(requestConfigBuilder.build());
    }

    private HttpRequestBase createApacheRequest(SdkHttpFullRequest request, String uri, String encodedParams) {
        switch (request.getHttpMethod()) {
            case HEAD: {
                return new HttpHead(uri);
            }
            case GET: {
                return new HttpGet(uri);
            }
            case DELETE: {
                return new HttpDelete(uri);
            }
            case OPTIONS: {
                return new HttpOptions(uri);
            }
            case PATCH: {
                return this.wrapEntity(request, new HttpPatch(uri), encodedParams);
            }
            case POST: {
                return this.wrapEntity(request, new HttpPost(uri), encodedParams);
            }
            case PUT: {
                return this.wrapEntity(request, new HttpPut(uri), encodedParams);
            }
        }
        throw new RuntimeException("Unknown HTTP method name: " + (Object)((Object)request.getHttpMethod()));
    }

    private HttpRequestBase wrapEntity(SdkHttpFullRequest request, HttpEntityEnclosingRequestBase entityEnclosingRequest, String encodedParams) {
        if (request.getContent() != null) {
            HttpEntity entity = new RepeatableInputStreamRequestEntity(request);
            if (request.getHeaders().get("Content-Length") == null) {
                entity = ApacheUtils.newBufferedHttpEntity(entity);
            }
            entityEnclosingRequest.setEntity(entity);
        }
        return entityEnclosingRequest;
    }

    private void addHeadersToRequest(HttpRequestBase httpRequest, SdkHttpFullRequest request) {
        httpRequest.addHeader("Host", this.getHostHeaderValue(request.getEndpoint()));
        request.getHeaders().entrySet().stream().filter(e -> !IGNORE_HEADERS.contains(e.getKey())).forEach(e -> ((List)e.getValue()).stream().forEach(h -> httpRequest.addHeader((String)e.getKey(), (String)h)));
        if (httpRequest.getHeaders("Content-Type") == null || httpRequest.getHeaders("Content-Type").length == 0) {
            httpRequest.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + StringUtils.lowerCase(DEFAULT_ENCODING));
        }
    }

    private String getHostHeaderValue(URI endpoint) {
        return SdkHttpUtils.isUsingNonDefaultPort(endpoint) ? endpoint.getHost() + ":" + endpoint.getPort() : endpoint.getHost();
    }
}

