/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache.internal.utils;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import software.amazon.awssdk.http.apache.ProxyConfiguration;

public class ApacheUtils {
    public static HttpEntity newStringEntity(String s) {
        try {
            return new StringEntity(s);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to create HTTP entity: " + e.getMessage(), e);
        }
    }

    public static HttpEntity newBufferedHttpEntity(HttpEntity entity) {
        try {
            return new BufferedHttpEntity(entity);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to create HTTP entity: " + e.getMessage(), e);
        }
    }

    public static HttpClientContext newClientContext(ProxyConfiguration proxyConfiguration, Map<String, ?> attributes) {
        HttpClientContext clientContext = new HttpClientContext();
        if (attributes != null && !attributes.isEmpty()) {
            for (Map.Entry<String, ?> entry : attributes.entrySet()) {
                clientContext.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        ApacheUtils.addPreemptiveAuthenticationProxy(clientContext, proxyConfiguration);
        return clientContext;
    }

    public static CredentialsProvider newProxyCredentialsProvider(ProxyConfiguration proxyConfiguration) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(ApacheUtils.newAuthScope(proxyConfiguration), ApacheUtils.newNtCredentials(proxyConfiguration));
        return provider;
    }

    private static Credentials newNtCredentials(ProxyConfiguration proxyConfiguration) {
        return new NTCredentials(proxyConfiguration.username(), proxyConfiguration.password(), proxyConfiguration.ntlmWorkstation(), proxyConfiguration.ntlmDomain());
    }

    private static AuthScope newAuthScope(ProxyConfiguration proxyConfiguration) {
        return new AuthScope(proxyConfiguration.endpoint().getHost(), proxyConfiguration.endpoint().getPort());
    }

    private static void addPreemptiveAuthenticationProxy(HttpClientContext clientContext, ProxyConfiguration proxyConfiguration) {
        if (proxyConfiguration.preemptiveBasicAuthenticationEnabled().booleanValue()) {
            HttpHost targetHost = new HttpHost(proxyConfiguration.endpoint().getHost(), proxyConfiguration.endpoint().getPort());
            CredentialsProvider credsProvider = ApacheUtils.newProxyCredentialsProvider(proxyConfiguration);
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(targetHost, basicAuth);
            clientContext.setCredentialsProvider(credsProvider);
            clientContext.setAuthCache(authCache);
        }
    }
}

