/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.async;

import java.nio.ByteBuffer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.handlers.AwsHandlerKeys;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.async.SdkHttpRequestProvider;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.IoUtils;

public class SimpleRequestProvider
implements SdkHttpRequestProvider {
    private final byte[] content;
    private final int length;

    public SimpleRequestProvider(SdkHttpFullRequest request) {
        if (request.getContent() != null) {
            request.getContent().mark(this.getReadLimit(request));
            this.content = FunctionalUtils.invokeSafely(() -> IoUtils.toByteArray(request.getContent()));
            FunctionalUtils.invokeSafely(() -> request.getContent().reset());
        } else {
            this.content = new byte[0];
        }
        this.length = this.content.length;
    }

    private int getReadLimit(SdkHttpFullRequest request) {
        return request.handlerContext(AwsHandlerKeys.REQUEST_CONFIG).getRequestClientOptions().getReadLimit();
    }

    @Override
    public long contentLength() {
        return this.length;
    }

    @Override
    public void subscribe(final Subscriber<? super ByteBuffer> s) {
        s.onSubscribe(new Subscription(){

            @Override
            public void request(long n) {
                s.onNext(ByteBuffer.wrap(SimpleRequestProvider.this.content));
                s.onComplete();
            }

            @Override
            public void cancel() {
            }
        });
    }
}

