/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.loader;

import java.util.Optional;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.SdkHttpService;
import software.amazon.awssdk.http.async.SdkAsyncHttpService;
import software.amazon.awssdk.http.loader.SdkHttpServiceProvider;
import software.amazon.awssdk.utils.SdkSystemSetting;
import software.amazon.awssdk.utils.SystemSetting;

final class SystemPropertyHttpServiceProvider<T>
implements SdkHttpServiceProvider<T> {
    private final SystemSetting implSetting;
    private final Class<T> serviceClass;

    private SystemPropertyHttpServiceProvider(SystemSetting implSetting, Class<T> serviceClass) {
        this.implSetting = implSetting;
        this.serviceClass = serviceClass;
    }

    @Override
    public Optional<T> loadService() {
        return this.implSetting.getStringValue().map(this::createServiceFromProperty);
    }

    private T createServiceFromProperty(String httpImplFqcn) {
        try {
            return this.serviceClass.cast(Class.forName(httpImplFqcn).newInstance());
        }
        catch (Exception e) {
            throw new SdkClientException(String.format("Unable to load the HTTP factory implementation from the %s system property. Ensure the class '%s' is present on the classpath and has a no-arg constructor", SdkSystemSetting.SYNC_HTTP_SERVICE_IMPL.property(), httpImplFqcn), e);
        }
    }

    static SystemPropertyHttpServiceProvider<SdkHttpService> syncProvider() {
        return new SystemPropertyHttpServiceProvider<SdkHttpService>(SdkSystemSetting.SYNC_HTTP_SERVICE_IMPL, SdkHttpService.class);
    }

    static SystemPropertyHttpServiceProvider<SdkAsyncHttpService> asyncProvider() {
        return new SystemPropertyHttpServiceProvider<SdkAsyncHttpService>(SdkSystemSetting.ASYNC_HTTP_SERVICE_IMPL, SdkAsyncHttpService.class);
    }
}

