/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty;

import java.time.Duration;
import java.util.Optional;
import software.amazon.awssdk.annotation.Immutable;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClientFactory;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Immutable
public final class NettySdkHttpClientFactory
implements SdkAsyncHttpClientFactory,
ToCopyableBuilder<Builder, NettySdkHttpClientFactory> {
    private final AttributeMap standardOptions;
    private final Optional<Boolean> trustAllCertificates;

    private NettySdkHttpClientFactory(DefaultBuilder builder) {
        this.standardOptions = builder.standardOptions.build();
        this.trustAllCertificates = Optional.ofNullable(builder.trustAllCertificates);
    }

    public Optional<Integer> maxConnectionsPerEndpoint() {
        return Optional.ofNullable(this.standardOptions.get(SdkHttpConfigurationOption.MAX_CONNECTIONS));
    }

    public Optional<Duration> socketTimeout() {
        return Optional.ofNullable(this.standardOptions.get(SdkHttpConfigurationOption.SOCKET_TIMEOUT));
    }

    public Optional<Duration> connectionTimeout() {
        return Optional.ofNullable(this.standardOptions.get(SdkHttpConfigurationOption.SOCKET_TIMEOUT));
    }

    public Optional<Boolean> trustAllCertificates() {
        return this.trustAllCertificates;
    }

    public SdkAsyncHttpClient createHttpClient() {
        return this.createHttpClientWithDefaults(AttributeMap.empty());
    }

    @Override
    public SdkAsyncHttpClient createHttpClientWithDefaults(AttributeMap serviceDefaults) {
        return new NettyNioAsyncHttpClient(this, this.standardOptions.merge(serviceDefaults).merge(SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS));
    }

    @Override
    public Builder toBuilder() {
        return new DefaultBuilder(this.standardOptions.toBuilder()).trustAllCertificates(this.trustAllCertificates.orElse(null));
    }

    public static Builder builder() {
        return new DefaultBuilder(AttributeMap.builder());
    }

    private static final class DefaultBuilder
    implements Builder {
        private Boolean trustAllCertificates;
        private final AttributeMap.Builder standardOptions;

        private DefaultBuilder(AttributeMap.Builder standardOptions) {
            this.standardOptions = standardOptions;
        }

        @Override
        public Builder maxConnectionsPerEndpoint(Integer maxConnectionsPerEndpoint) {
            this.standardOptions.put(SdkHttpConfigurationOption.MAX_CONNECTIONS, maxConnectionsPerEndpoint);
            return this;
        }

        public void setMaxConnectionsPerEndpoint(Integer maxConnectionsPerEndpoint) {
            this.maxConnectionsPerEndpoint(maxConnectionsPerEndpoint);
        }

        @Override
        public Builder socketTimeout(Duration socketTimeout) {
            this.standardOptions.put(SdkHttpConfigurationOption.SOCKET_TIMEOUT, socketTimeout);
            return this;
        }

        public void setSocketTimeout(Duration socketTimeout) {
            this.socketTimeout(socketTimeout);
        }

        @Override
        public Builder connectionTimeout(Duration connectionTimeout) {
            this.standardOptions.put(SdkHttpConfigurationOption.CONNECTION_TIMEOUT, connectionTimeout);
            return this;
        }

        public void setConnectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout(connectionTimeout);
        }

        @Override
        public Builder trustAllCertificates(Boolean trustAllCertificates) {
            this.trustAllCertificates = trustAllCertificates;
            return this;
        }

        public void setTrustAllCertificates(Boolean trustAllCertificates) {
            this.trustAllCertificates(trustAllCertificates);
        }

        @Override
        public NettySdkHttpClientFactory build() {
            return new NettySdkHttpClientFactory(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NettySdkHttpClientFactory> {
        public Builder maxConnectionsPerEndpoint(Integer var1);

        public Builder socketTimeout(Duration var1);

        public Builder connectionTimeout(Duration var1);

        public Builder trustAllCertificates(Boolean var1);
    }
}

