/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringEncoder;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.utils.StringUtils;

public final class RequestAdapter {
    public HttpRequest adapt(SdkHttpRequest sdkRequest) {
        String uri = this.uriFrom(sdkRequest);
        HttpMethod method = RequestAdapter.toNettyHttpMethod(sdkRequest.getHttpMethod());
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, method, uri, headers);
        sdkRequest.getHeaders().forEach(request.headers()::add);
        return request;
    }

    private String uriFrom(SdkHttpRequest sdkRequest) {
        StringBuilder uriBuilder = new StringBuilder(sdkRequest.getEndpoint().toString());
        if (StringUtils.isNotBlank(sdkRequest.getResourcePath())) {
            uriBuilder.append(sdkRequest.getResourcePath());
        }
        QueryStringEncoder encoder = new QueryStringEncoder(uriBuilder.toString());
        sdkRequest.getParameters().forEach((k, values) -> values.forEach(v -> encoder.addParam((String)k, (String)v)));
        return encoder.toString();
    }

    private static HttpMethod toNettyHttpMethod(SdkHttpMethod method) {
        return HttpMethod.valueOf(method.name());
    }
}

