/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import com.typesafe.netty.HandlerPublisher;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKeys;
import software.amazon.awssdk.http.nio.netty.internal.RequestContext;
import software.amazon.awssdk.utils.Logger;

@ChannelHandler.Sharable
class ResponseHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final Logger log = Logger.loggerFor(ResponseHandler.class);

    ResponseHandler() {
    }

    @Override
    protected void channelRead0(ChannelHandlerContext channelContext, HttpObject msg) throws Exception {
        RequestContext requestContext = channelContext.channel().attr(ChannelAttributeKeys.REQUEST_CONTEXT_KEY).get();
        HandlerPublisher<ByteBuffer> publisher = channelContext.channel().attr(ChannelAttributeKeys.PUBLISHER_KEY).get();
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            SdkHttpFullResponse sdkResponse = SdkHttpFullResponse.builder().headers(ResponseHandler.fromNettyHeaders(response.headers())).statusCode(response.status().code()).statusText(response.status().reasonPhrase()).build();
            requestContext.handler().headersReceived(sdkResponse);
        }
        if (msg instanceof HttpContent) {
            HttpContent content;
            Boolean hasCalledOnStream = channelContext.channel().attr(ChannelAttributeKeys.HAS_CALLED_ON_STREAM).get();
            if (!Boolean.TRUE.equals(hasCalledOnStream)) {
                requestContext.handler().onStream(publisher);
                channelContext.channel().attr(ChannelAttributeKeys.HAS_CALLED_ON_STREAM).set(Boolean.TRUE);
            }
            if ((content = (HttpContent)msg).content().readableBytes() > 0) {
                channelContext.fireChannelRead(content.content().nioBuffer());
            }
            if (msg instanceof LastHttpContent) {
                channelContext.pipeline().remove(publisher);
                requestContext.channelPool().release(channelContext.channel());
            }
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        RequestContext requestContext = ctx.channel().attr(ChannelAttributeKeys.REQUEST_CONTEXT_KEY).get();
        log.error(() -> "Exception processing request: " + requestContext.sdkRequest(), cause);
        requestContext.handler().exceptionOccurred(cause);
        requestContext.channelPool().release(ctx.channel());
        ctx.fireExceptionCaught(cause);
    }

    private static Map<String, List<String>> fromNettyHeaders(HttpHeaders headers) {
        return headers.entries().stream().collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }
}

