/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.http.async.AbortableRunnable;
import software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKeys;
import software.amazon.awssdk.http.nio.netty.internal.CompletingHandlerPublisher;
import software.amazon.awssdk.http.nio.netty.internal.NettyHttpContentSubscriber;
import software.amazon.awssdk.http.nio.netty.internal.RequestContext;
import software.amazon.awssdk.utils.Logger;

public final class RunnableRequest
implements AbortableRunnable {
    private static final Logger log = Logger.loggerFor(RunnableRequest.class);
    private final RequestContext context;
    private volatile Channel channel;

    public RunnableRequest(RequestContext context) {
        this.context = context;
    }

    @Override
    public void run() {
        this.context.channelPool().acquire().addListener(channelFuture -> {
            if (channelFuture.isSuccess()) {
                this.channel = (Channel)channelFuture.getNow();
                this.channel.attr(ChannelAttributeKeys.REQUEST_CONTEXT_KEY).set(this.context);
                this.channel.attr(ChannelAttributeKeys.HAS_CALLED_ON_STREAM).set(Boolean.FALSE);
                Subscriber<ByteBuffer> adaptedSubscriber = this.addBackpressureHandlers();
                this.makeRequest(this.context.nettyRequest(), adaptedSubscriber);
            } else {
                this.handleFailure(() -> "Failed to create connection to " + this.endpoint(), channelFuture.cause());
            }
        });
    }

    @Override
    public void abort() {
        if (this.channel != null) {
            this.channel.disconnect().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)ignored -> this.context.channelPool().release(this.channel)));
        }
    }

    private Subscriber<ByteBuffer> addBackpressureHandlers() {
        NettyHttpContentSubscriber httpContentSubscriber = new NettyHttpContentSubscriber(this.channel);
        Subscriber<ByteBuffer> byteBufferSubscriber = httpContentSubscriber.adapt();
        CompletingHandlerPublisher publisher = new CompletingHandlerPublisher((EventExecutor)this.channel.eventLoop(), this.context.handler());
        this.channel.pipeline().addLast(publisher, httpContentSubscriber);
        this.channel.attr(ChannelAttributeKeys.PUBLISHER_KEY).set(publisher);
        return byteBufferSubscriber;
    }

    private void makeRequest(HttpRequest request, Subscriber<ByteBuffer> subscriber) {
        log.debug(() -> "Writing request: " + request);
        this.channel.write(request).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)wireCall -> {
            if (!wireCall.isSuccess()) {
                this.handleFailure(() -> "Failed to make request to " + this.endpoint(), wireCall.cause());
            }
        }));
        this.context.sdkRequestProvider().subscribe(subscriber);
    }

    private URI endpoint() {
        return this.context.sdkRequest().getEndpoint();
    }

    private void handleFailure(Supplier<String> msg, Throwable cause) {
        log.error(msg, cause);
        this.context.handler().exceptionOccurred(cause);
        if (this.channel != null) {
            this.context.channelPool().release(this.channel);
        }
    }
}

