/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.EmptyByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.http.async.SdkRequestChannel;

final class SdkNettyHttpRequestChannel
implements SdkRequestChannel {
    private final Channel channel;
    private final Consumer<Throwable> errorHandler;
    private final Runnable abort;

    SdkNettyHttpRequestChannel(Channel channel, Consumer<Throwable> errorHandler, Runnable abort) {
        this.channel = channel;
        this.errorHandler = errorHandler;
        this.abort = abort;
    }

    @Override
    public void write(ByteBuffer data) {
        this.channel.writeAndFlush(new DefaultHttpContent(this.toByteBuf(this.channel.alloc(), data))).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)this::handleFailure));
    }

    @Override
    public void complete() {
        this.channel.writeAndFlush(new DefaultLastHttpContent(new EmptyByteBuf(this.channel.alloc()))).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)this::handleFailure));
    }

    @Override
    public void abort() {
        this.abort.run();
    }

    @ReviewBeforeRelease(value="Unpooled vs channel.alloc? channel.alloc seems to be preferred but we should test this more thoroughly under high concurrency.")
    private ByteBuf toByteBuf(ByteBufAllocator allocator, ByteBuffer data) {
        ByteBuf buffer = allocator.buffer(data.limit());
        buffer.writeBytes(data);
        return buffer;
    }

    private void handleFailure(Future<? super Void> future) {
        if (!future.isSuccess()) {
            this.errorHandler.accept(future.cause());
        }
    }
}

