/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.pipeline.stages;

import software.amazon.awssdk.RequestExecutionContext;
import software.amazon.awssdk.Response;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.pipeline.RequestPipeline;
import software.amazon.awssdk.http.pipeline.RequestToResponsePipeline;
import software.amazon.awssdk.metrics.spi.AwsRequestMetrics;
import software.amazon.awssdk.retry.RetryUtils;

public class ExceptionReportingStage<OutputT>
implements RequestToResponsePipeline<OutputT> {
    private final RequestPipeline<SdkHttpFullRequest, Response<OutputT>> wrapped;

    public ExceptionReportingStage(RequestPipeline<SdkHttpFullRequest, Response<OutputT>> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public Response<OutputT> execute(SdkHttpFullRequest input, RequestExecutionContext context) throws Exception {
        try {
            Response<OutputT> response = this.wrapped.execute(input, context);
            if (response.isFailure()) {
                this.captureExceptionMetrics(context.awsRequestMetrics(), response.getException());
            }
            return response;
        }
        catch (Exception e) {
            throw this.captureExceptionMetrics(context.awsRequestMetrics(), e);
        }
    }

    private <T extends Throwable> T captureExceptionMetrics(AwsRequestMetrics awsRequestMetrics, T throwable) {
        awsRequestMetrics.incrementCounterWith(AwsRequestMetrics.Field.Exception).addProperty(AwsRequestMetrics.Field.Exception, throwable);
        if (throwable instanceof SdkBaseException && RetryUtils.isThrottlingException((SdkBaseException)throwable)) {
            awsRequestMetrics.incrementCounterWith(AwsRequestMetrics.Field.ThrottleException).addProperty(AwsRequestMetrics.Field.ThrottleException, throwable);
        }
        return throwable;
    }
}

