/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.pipeline.stages;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import software.amazon.awssdk.RequestExecutionContext;
import software.amazon.awssdk.Response;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.event.ProgressEventType;
import software.amazon.awssdk.event.ProgressListener;
import software.amazon.awssdk.event.SdkProgressPublisher;
import software.amazon.awssdk.http.AmazonHttpClient;
import software.amazon.awssdk.http.HttpResponse;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.http.pipeline.RequestPipeline;
import software.amazon.awssdk.metrics.spi.AwsRequestMetrics;

public class HandleResponseStage<OutputT>
implements RequestPipeline<HttpResponse, Response<OutputT>> {
    private final HttpResponseHandler<OutputT> successResponseHandler;
    private final HttpResponseHandler<? extends SdkBaseException> errorResponseHandler;

    public HandleResponseStage(HttpResponseHandler<OutputT> successResponseHandler, HttpResponseHandler<? extends SdkBaseException> errorResponseHandler) {
        this.successResponseHandler = successResponseHandler;
        this.errorResponseHandler = errorResponseHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<OutputT> execute(HttpResponse httpResponse, RequestExecutionContext context) throws Exception {
        Optional<Response<OutputT>> response = Optional.empty();
        try {
            response = Optional.of(this.handleResponse(httpResponse, context));
        }
        finally {
            this.closeInputStreamIfNeeded(httpResponse, this.didRequestFail(response));
        }
        return response.orElseThrow(() -> new IllegalStateException("Response should not be null"));
    }

    private Response<OutputT> handleResponse(HttpResponse httpResponse, RequestExecutionContext context) throws IOException, InterruptedException {
        if (httpResponse.isSuccessful()) {
            return Response.fromSuccess(this.handleSuccessResponse(httpResponse, context), httpResponse);
        }
        return Response.fromFailure(this.handleErrorResponse(httpResponse), httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutputT handleSuccessResponse(HttpResponse httpResponse, RequestExecutionContext context) throws IOException, InterruptedException {
        context.awsRequestMetrics().addProperty(AwsRequestMetrics.Field.StatusCode, (Object)httpResponse.getStatusCode());
        ProgressListener listener = context.requestConfig().getProgressListener();
        try {
            OutputT awsResponse;
            context.awsRequestMetrics().startEvent(AwsRequestMetrics.Field.ResponseProcessingTime);
            SdkProgressPublisher.publishProgress(listener, ProgressEventType.HTTP_RESPONSE_STARTED_EVENT);
            try {
                awsResponse = this.successResponseHandler.handle(httpResponse);
            }
            finally {
                context.awsRequestMetrics().endEvent(AwsRequestMetrics.Field.ResponseProcessingTime);
            }
            SdkProgressPublisher.publishProgress(listener, ProgressEventType.HTTP_RESPONSE_COMPLETED_EVENT);
            return awsResponse;
        }
        catch (IOException | InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = "Unable to unmarshall response (" + e.getMessage() + "). Response Code: " + httpResponse.getStatusCode() + ", Response Text: " + httpResponse.getStatusText();
            throw new SdkClientException(errorMessage, e);
        }
    }

    private SdkBaseException handleErrorResponse(HttpResponse httpResponse) throws IOException, InterruptedException {
        try {
            SdkBaseException exception = this.errorResponseHandler.handle(httpResponse);
            exception.fillInStackTrace();
            if (AmazonHttpClient.REQUEST_LOG.isDebugEnabled()) {
                AmazonHttpClient.REQUEST_LOG.debug("Received error response: " + exception);
            }
            return exception;
        }
        catch (IOException | InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = String.format("Unable to unmarshall error response (%s). Response Code: %d, Response Text: %s", e.getMessage(), httpResponse.getStatusCode(), httpResponse.getStatusText());
            throw new SdkClientException(errorMessage, e);
        }
    }

    private void closeInputStreamIfNeeded(HttpResponse httpResponse, boolean didRequestFail) throws IOException {
        Optional<InputStream> inputStreamOptional = Optional.ofNullable(httpResponse).map(HttpResponse::getContent).filter(i -> didRequestFail || !this.successResponseHandler.needsConnectionLeftOpen());
        if (inputStreamOptional.isPresent()) {
            inputStreamOptional.get().close();
        }
    }

    private boolean didRequestFail(Optional<Response<OutputT>> response) {
        return response.map(Response::isFailure).orElse(true);
    }
}

