/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.pipeline.stages;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.RequestExecutionContext;
import software.amazon.awssdk.Response;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.event.ProgressEventType;
import software.amazon.awssdk.event.ProgressListener;
import software.amazon.awssdk.event.SdkProgressPublisher;
import software.amazon.awssdk.http.AmazonHttpClient;
import software.amazon.awssdk.http.HttpClientDependencies;
import software.amazon.awssdk.http.HttpResponse;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.SdkHttpResponseAdapter;
import software.amazon.awssdk.http.SdkRequestContext;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.async.SdkHttpRequestProvider;
import software.amazon.awssdk.http.async.SdkHttpResponseHandler;
import software.amazon.awssdk.http.async.SimpleRequestProvider;
import software.amazon.awssdk.http.pipeline.RequestPipeline;

public class MakeAsyncHttpRequestStage<OutputT>
implements RequestPipeline<SdkHttpFullRequest, CompletableFuture<Response<OutputT>>> {
    private final SdkAsyncHttpClient sdkAsyncHttpClient;
    private final SdkHttpResponseHandler<OutputT> responseHandler;
    private final SdkHttpResponseHandler<? extends SdkBaseException> errorResponseHandler;

    public MakeAsyncHttpRequestStage(SdkHttpResponseHandler<OutputT> responseHandler, SdkHttpResponseHandler<? extends SdkBaseException> errorResponseHandler, HttpClientDependencies dependencies) {
        this.responseHandler = responseHandler;
        this.errorResponseHandler = errorResponseHandler;
        this.sdkAsyncHttpClient = dependencies.sdkAsyncHttpClient();
    }

    @Override
    public CompletableFuture<Response<OutputT>> execute(SdkHttpFullRequest request, RequestExecutionContext context) throws Exception {
        AmazonHttpClient.checkInterrupted();
        ProgressListener listener = context.requestConfig().getProgressListener();
        SdkProgressPublisher.publishProgress(listener, ProgressEventType.HTTP_REQUEST_STARTED_EVENT);
        return this.executeHttpRequest(request, context, listener);
    }

    private CompletableFuture<Response<OutputT>> executeHttpRequest(SdkHttpFullRequest request, RequestExecutionContext context, ProgressListener listener) throws Exception {
        CompletableFuture<Response<OutputT>> future = new CompletableFuture<Response<OutputT>>();
        ResponseHandler handler = new ResponseHandler(request, future, listener);
        SdkHttpRequestProvider requestProvider = context.requestProvider() == null ? new SimpleRequestProvider(request) : context.requestProvider();
        SdkHttpFullRequest requestWithContentLength = this.getRequestWithContentLength(request, requestProvider);
        this.sdkAsyncHttpClient.prepareRequest(requestWithContentLength, SdkRequestContext.builder().metrics(context.awsRequestMetrics()).build(), requestProvider, handler).run();
        return future;
    }

    private SdkHttpFullRequest getRequestWithContentLength(SdkHttpFullRequest request, SdkHttpRequestProvider requestProvider) {
        if (this.shouldSetContentLength(request, requestProvider)) {
            return (SdkHttpFullRequest)((SdkHttpFullRequest.Builder)request.toBuilder()).header("Content-Length", String.valueOf(requestProvider.contentLength())).build();
        }
        return request;
    }

    private boolean shouldSetContentLength(SdkHttpFullRequest request, SdkHttpRequestProvider requestProvider) {
        return requestProvider != null && !request.getFirstHeaderValue("Content-Length").isPresent() && request.getHttpMethod() != SdkHttpMethod.GET && request.getHttpMethod() != SdkHttpMethod.HEAD;
    }

    private class ResponseHandler
    implements SdkHttpResponseHandler<Response<OutputT>> {
        private final ProgressListener listener;
        private final SdkHttpFullRequest request;
        private final CompletableFuture<Response<OutputT>> future;
        private volatile SdkHttpResponse response;
        private volatile boolean isSuccess = false;

        private ResponseHandler(SdkHttpFullRequest request, CompletableFuture<Response<OutputT>> future, ProgressListener listener) {
            this.listener = listener;
            this.request = request;
            this.future = future;
        }

        @Override
        public void headersReceived(SdkHttpResponse response) {
            if (this.isSuccessful(response.getStatusCode())) {
                this.isSuccess = true;
                MakeAsyncHttpRequestStage.this.responseHandler.headersReceived(response);
            } else {
                MakeAsyncHttpRequestStage.this.errorResponseHandler.headersReceived(response);
            }
            this.response = response;
        }

        @Override
        public void onStream(Publisher<ByteBuffer> publisher) {
            if (this.isSuccess) {
                MakeAsyncHttpRequestStage.this.responseHandler.onStream(publisher);
            } else {
                MakeAsyncHttpRequestStage.this.errorResponseHandler.onStream(publisher);
            }
        }

        @Override
        public void exceptionOccurred(Throwable throwable) {
            MakeAsyncHttpRequestStage.this.responseHandler.exceptionOccurred(throwable);
            this.future.completeExceptionally(throwable);
        }

        @Override
        public Response<OutputT> complete() {
            SdkProgressPublisher.publishProgress(this.listener, ProgressEventType.HTTP_REQUEST_COMPLETED_EVENT);
            HttpResponse httpResponse = SdkHttpResponseAdapter.adapt(false, this.request, (SdkHttpFullResponse)this.response);
            Response toReturn = this.handleResponse(httpResponse);
            this.future.complete(toReturn);
            return toReturn;
        }

        private boolean isSuccessful(int statusCode) {
            return statusCode / 100 == 2;
        }

        private Response<OutputT> handleResponse(HttpResponse httpResponse) {
            if (this.isSuccess) {
                return Response.fromSuccess(MakeAsyncHttpRequestStage.this.responseHandler.complete(), httpResponse);
            }
            return Response.fromFailure((SdkBaseException)MakeAsyncHttpRequestStage.this.errorResponseHandler.complete(), httpResponse);
        }
    }
}

