/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.pipeline.stages;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import software.amazon.awssdk.RequestExecutionContext;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.handlers.AwsHandlerKeys;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.pipeline.MutableRequestToRequestPipeline;
import software.amazon.awssdk.util.SdkHttpUtils;
import software.amazon.awssdk.utils.StringUtils;

@ReviewBeforeRelease(value="Might only need to do this for certain protocols - ie query?")
public final class MoveParametersToBodyStage
implements MutableRequestToRequestPipeline {
    @Override
    public SdkHttpFullRequest.Builder execute(SdkHttpFullRequest.Builder input, RequestExecutionContext context) {
        if (this.shouldPutParamsInBody(input)) {
            return this.putParams(input);
        }
        return input;
    }

    private boolean shouldPutParamsInBody(SdkHttpFullRequest.Builder input) {
        return this.notSimpleDb(input) && input.getHttpMethod() == SdkHttpMethod.POST && input.getContent() == null && input.getParameters() != null && input.getParameters().size() > 0;
    }

    @ReviewBeforeRelease(value="SigV2 expects query params to be signed as query params despite being in the body. Moving before signing breaks SimpleDB which still uses SigV2. Probably the best thing to do is make the SigV2 signer be aware that params are being moved into the body and move them back out and unencode and sign them as query params. We did a similiar thing in the V4 signer in 1.11.x but I'd rather have the grossness in the legacy signer implementation")
    private boolean notSimpleDb(SdkHttpFullRequest.Builder input) {
        return !"SimpleDBClient".equals(input.handlerContext(AwsHandlerKeys.SERVICE_NAME));
    }

    private SdkHttpFullRequest.Builder putParams(SdkHttpFullRequest.Builder input) {
        byte[] params = SdkHttpUtils.encodeParameters(input).getBytes(StandardCharsets.UTF_8);
        return input.clearQueryParameters().content(new ByteArrayInputStream(params)).header("Content-Length", Collections.singletonList(String.valueOf(params.length))).header("Content-Type", Collections.singletonList("application/x-www-form-urlencoded; charset=" + StringUtils.lowerCase(StandardCharsets.UTF_8.toString())));
    }
}

