/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.pipeline.stages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.RequestExecutionContext;
import software.amazon.awssdk.event.SdkProgressPublisher;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.StreamManagingStage;
import software.amazon.awssdk.http.pipeline.RequestToRequestPipeline;

public class ReportRequestContentLengthStage
implements RequestToRequestPipeline {
    private static final Log LOG = LogFactory.getLog(StreamManagingStage.class);

    @Override
    public SdkHttpFullRequest execute(SdkHttpFullRequest request, RequestExecutionContext context) throws Exception {
        try {
            request.getFirstHeaderValue("Content-Length").map(Long::parseLong).ifPresent(l -> SdkProgressPublisher.publishRequestContentLength(context.requestConfig().getProgressListener(), l));
        }
        catch (NumberFormatException e) {
            LOG.warn("Cannot parse the Content-Length header of the request.");
        }
        return request;
    }
}

