/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.internal;

import software.amazon.awssdk.internal.CustomBackoffStrategy;

public class DynamoDbBackoffStrategy
extends CustomBackoffStrategy {
    public static final CustomBackoffStrategy DEFAULT = new DynamoDbBackoffStrategy();

    @Override
    public int getBackoffPeriod(int retries) {
        if (retries <= 0) {
            return 0;
        }
        int delay = 50 * (int)Math.pow(2.0, retries - 1);
        if (delay < 0) {
            delay = Integer.MAX_VALUE;
        }
        return delay;
    }
}

