/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.internal.http.response;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.AmazonWebServiceResponse;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.http.AmazonHttpClient;
import software.amazon.awssdk.http.HttpResponse;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.http.SdkHttpMetadata;
import software.amazon.awssdk.metrics.spi.AwsRequestMetrics;

@SdkInternalApi
public class AwsResponseHandlerAdapter<T>
implements HttpResponseHandler<T> {
    private static final Log REQUEST_ID_LOG = LogFactory.getLog("software.amazon.awssdk.requestId");
    private static final Log REQUEST_LOG = AmazonHttpClient.REQUEST_LOG;
    private final HttpResponseHandler<AmazonWebServiceResponse<T>> delegate;
    private final AwsRequestMetrics awsRequestMetrics;

    public AwsResponseHandlerAdapter(HttpResponseHandler<AmazonWebServiceResponse<T>> delegate, AwsRequestMetrics awsRequestMetrics) {
        this.delegate = delegate;
        this.awsRequestMetrics = awsRequestMetrics;
    }

    @Override
    public T handle(HttpResponse response) throws Exception {
        AmazonWebServiceResponse<T> awsResponse = this.delegate.handle(response);
        if (awsResponse == null) {
            throw new RuntimeException("Unable to unmarshall response metadata. Response Code: " + response.getStatusCode() + ", Response Text: " + response.getStatusText());
        }
        String awsRequestId = awsResponse.getRequestId();
        if (REQUEST_LOG.isDebugEnabled()) {
            REQUEST_LOG.debug("Received successful response: " + response.getStatusCode() + ", AWS Request ID: " + awsRequestId);
        }
        if (!this.logHeaderRequestId(response)) {
            this.logResponseRequestId(awsRequestId);
        }
        this.awsRequestMetrics.addProperty(AwsRequestMetrics.Field.AWSRequestID, (Object)awsRequestId);
        return this.fillInResponseMetadata(awsResponse, response);
    }

    private <T> T fillInResponseMetadata(AmazonWebServiceResponse<T> awsResponse, HttpResponse httpResponse) {
        T result = awsResponse.getResult();
        if (result instanceof AmazonWebServiceResult) {
            ((AmazonWebServiceResult)result).setSdkResponseMetadata(awsResponse.getResponseMetadata()).setSdkHttpMetadata(SdkHttpMetadata.from(httpResponse));
        }
        return result;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return this.delegate.needsConnectionLeftOpen();
    }

    private boolean logHeaderRequestId(HttpResponse response) {
        boolean isHeaderReqIdAvail;
        String reqIdHeader = response.getHeaders().get("x-amzn-RequestId");
        boolean bl = isHeaderReqIdAvail = reqIdHeader != null;
        if (REQUEST_ID_LOG.isDebugEnabled() || REQUEST_LOG.isDebugEnabled()) {
            String msg = "x-amzn-RequestId: " + (isHeaderReqIdAvail ? reqIdHeader : "not available");
            if (REQUEST_ID_LOG.isDebugEnabled()) {
                REQUEST_ID_LOG.debug(msg);
            } else {
                REQUEST_LOG.debug(msg);
            }
        }
        return isHeaderReqIdAvail;
    }

    private void logResponseRequestId(String awsRequestId) {
        if (REQUEST_ID_LOG.isDebugEnabled() || REQUEST_LOG.isDebugEnabled()) {
            String msg = "AWS Request ID: " + (awsRequestId == null ? "not available" : awsRequestId);
            if (REQUEST_ID_LOG.isDebugEnabled()) {
                REQUEST_ID_LOG.debug(msg);
            } else {
                REQUEST_LOG.debug(msg);
            }
        }
    }
}

