/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.internal.http.timers;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.annotation.SdkInternalApi;

@SdkInternalApi
public class TimeoutThreadPoolBuilder {
    public static ScheduledThreadPoolExecutor buildDefaultTimeoutThreadPool(String name) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(5, TimeoutThreadPoolBuilder.getThreadFactory(name));
        executor.setRemoveOnCancelPolicy(true);
        executor.setKeepAliveTime(5L, TimeUnit.SECONDS);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    private static ThreadFactory getThreadFactory(final String name) {
        return new ThreadFactory(){
            private int threadCount = 1;

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                if (name != null) {
                    thread.setName(name + "-" + this.threadCount++);
                }
                thread.setPriority(10);
                return thread;
            }
        };
    }
}

