/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.internal.io;

import java.io.IOException;
import java.io.InputStream;
import software.amazon.awssdk.internal.io.DelegateInputStream;
import software.amazon.awssdk.metrics.spi.AwsRequestMetrics;

public class MetricsInputStream
extends DelegateInputStream {
    private AwsRequestMetrics metrics;

    public MetricsInputStream(InputStream in) {
        super(in);
    }

    public void setMetrics(AwsRequestMetrics metrics) {
        this.metrics = metrics;
    }

    @Override
    public int read() throws IOException {
        if (this.metrics != null) {
            this.metrics.startEvent(AwsRequestMetrics.Field.HttpSocketReadTime);
        }
        try {
            int n = this.in.read();
            return n;
        }
        finally {
            if (this.metrics != null) {
                this.metrics.endEvent(AwsRequestMetrics.Field.HttpSocketReadTime);
            }
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.metrics != null) {
            this.metrics.startEvent(AwsRequestMetrics.Field.HttpSocketReadTime);
        }
        try {
            int n = this.in.read(b);
            return n;
        }
        finally {
            if (this.metrics != null) {
                this.metrics.endEvent(AwsRequestMetrics.Field.HttpSocketReadTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.metrics != null) {
            this.metrics.startEvent(AwsRequestMetrics.Field.HttpSocketReadTime);
        }
        try {
            int n = this.in.read(b, off, len);
            return n;
        }
        finally {
            if (this.metrics != null) {
                this.metrics.endEvent(AwsRequestMetrics.Field.HttpSocketReadTime);
            }
        }
    }
}

