/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.jmespath;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import java.util.Arrays;
import java.util.List;
import software.amazon.awssdk.jmespath.InvalidTypeException;
import software.amazon.awssdk.jmespath.JmesPathExpression;
import software.amazon.awssdk.jmespath.JmesPathFunction;

public class JmesPathLengthFunction
extends JmesPathFunction {
    public JmesPathLengthFunction(JmesPathExpression ... expressions) {
        this(Arrays.asList(expressions));
    }

    public JmesPathLengthFunction(List<JmesPathExpression> arguments) {
        super(arguments);
    }

    private static IntNode getStringLength(JsonNode arg) {
        return new IntNode(arg.asText().length());
    }

    @Override
    public JsonNode evaluate(List<JsonNode> evaluatedArgs) throws InvalidTypeException {
        JsonNode arg = evaluatedArgs.get(0);
        if (arg.isTextual()) {
            return JmesPathLengthFunction.getStringLength(arg);
        }
        if (arg.isArray() || arg.isObject()) {
            return new IntNode(arg.size());
        }
        throw new InvalidTypeException("Type mismatch. Expecting a string or an array or an object.");
    }
}

