/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.http.HttpResponse;
import software.amazon.awssdk.utils.IoUtils;

@SdkInternalApi
@ReviewBeforeRelease(value="Do we need this? It isn't well encapsulated because of storing non-copied arrays.")
public class JsonContent {
    private static final Log LOG = LogFactory.getLog(JsonContent.class);
    private final byte[] rawContent;
    private final JsonNode jsonNode;

    public JsonContent(byte[] rawJsonContent, JsonNode jsonNode) {
        this.rawContent = rawJsonContent;
        this.jsonNode = jsonNode;
    }

    private JsonContent(byte[] rawJsonContent, ObjectMapper mapper) {
        this.rawContent = rawJsonContent;
        this.jsonNode = JsonContent.parseJsonContent(rawJsonContent, mapper);
    }

    public static JsonContent createJsonContent(HttpResponse httpResponse, JsonFactory jsonFactory) {
        byte[] rawJsonContent = null;
        try {
            if (httpResponse.getContent() != null) {
                rawJsonContent = IoUtils.toByteArray(httpResponse.getContent());
            }
        }
        catch (Exception e) {
            LOG.info("Unable to read HTTP response content", e);
        }
        return new JsonContent(rawJsonContent, new ObjectMapper(jsonFactory).configure(JsonParser.Feature.ALLOW_COMMENTS, true));
    }

    private static JsonNode parseJsonContent(byte[] rawJsonContent, ObjectMapper mapper) {
        if (rawJsonContent == null) {
            return mapper.createObjectNode();
        }
        try {
            return mapper.readTree(rawJsonContent);
        }
        catch (Exception e) {
            LOG.info("Unable to parse HTTP response content", e);
            return mapper.createObjectNode();
        }
    }

    public byte[] getRawContent() {
        return this.rawContent;
    }

    public JsonNode getJsonNode() {
        return this.jsonNode;
    }
}

