/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.json;

import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.protocol.OperationInfo;
import software.amazon.awssdk.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.protocol.json.StructuredJsonGenerator;
import software.amazon.awssdk.protocol.json.internal.JsonProtocolMarshaller;
import software.amazon.awssdk.protocol.json.internal.NullAsEmptyBodyProtocolRequestMarshaller;

@SdkProtectedApi
public class JsonProtocolMarshallerBuilder<T> {
    private StructuredJsonGenerator jsonGenerator;
    private String contentType;
    private OperationInfo operationInfo;
    private boolean sendExplicitNullForPayload;
    private T originalRequest;

    public static <T> JsonProtocolMarshallerBuilder<T> standard() {
        return new JsonProtocolMarshallerBuilder<T>();
    }

    public JsonProtocolMarshallerBuilder<T> jsonGenerator(StructuredJsonGenerator jsonGenerator) {
        this.jsonGenerator = jsonGenerator;
        return this;
    }

    public JsonProtocolMarshallerBuilder<T> contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public JsonProtocolMarshallerBuilder<T> operationInfo(OperationInfo operationInfo) {
        this.operationInfo = operationInfo;
        return this;
    }

    public JsonProtocolMarshallerBuilder<T> sendExplicitNullForPayload(boolean sendExplicitNullForPayload) {
        this.sendExplicitNullForPayload = sendExplicitNullForPayload;
        return this;
    }

    public JsonProtocolMarshallerBuilder<T> originalRequest(T originalRequest) {
        this.originalRequest = originalRequest;
        return this;
    }

    public ProtocolRequestMarshaller<T> build() {
        JsonProtocolMarshaller<T> protocolMarshaller = new JsonProtocolMarshaller<T>(this.jsonGenerator, this.contentType, this.operationInfo, this.originalRequest);
        return this.sendExplicitNullForPayload ? protocolMarshaller : new NullAsEmptyBodyProtocolRequestMarshaller<T>(protocolMarshaller);
    }
}

