/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.json;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.AwsSystemSetting;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.annotation.SdkTestInternalApi;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.async.AsyncResponseHandler;
import software.amazon.awssdk.http.HttpResponse;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpResponseAdapter;
import software.amazon.awssdk.http.async.SdkHttpResponseHandler;
import software.amazon.awssdk.http.async.UnmarshallingAsyncResponseHandler;
import software.amazon.awssdk.protocol.OperationInfo;
import software.amazon.awssdk.protocol.Protocol;
import software.amazon.awssdk.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonContentTypeResolver;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.JsonProtocolMarshallerBuilder;
import software.amazon.awssdk.protocol.json.SdkStructuredCborFactory;
import software.amazon.awssdk.protocol.json.SdkStructuredIonFactory;
import software.amazon.awssdk.protocol.json.SdkStructuredJsonFactory;
import software.amazon.awssdk.protocol.json.SdkStructuredPlainJsonFactory;
import software.amazon.awssdk.protocol.json.StructuredJsonGenerator;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.JsonErrorUnmarshaller;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContextImpl;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.runtime.transform.UnmarshallingStreamingResponseHandler;
import software.amazon.awssdk.sync.StreamingResponseHandler;

@ThreadSafe
@SdkProtectedApi
public class SdkJsonProtocolFactory {
    private final JsonClientMetadata metadata;
    private final List<JsonErrorUnmarshaller> errorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();

    public SdkJsonProtocolFactory(JsonClientMetadata metadata) {
        this.metadata = metadata;
        this.createErrorUnmarshallers();
    }

    public <T> ProtocolRequestMarshaller<T> createProtocolMarshaller(OperationInfo operationInfo, T origRequest) {
        return JsonProtocolMarshallerBuilder.standard().jsonGenerator(this.createGenerator(operationInfo)).contentType(this.getContentType()).operationInfo(operationInfo).originalRequest(origRequest).sendExplicitNullForPayload(false).build();
    }

    private StructuredJsonGenerator createGenerator(OperationInfo operationInfo) {
        if (operationInfo.hasPayloadMembers() || operationInfo.protocol() == Protocol.AWS_JSON) {
            return this.createGenerator();
        }
        return StructuredJsonGenerator.NO_OP;
    }

    @SdkTestInternalApi
    StructuredJsonGenerator createGenerator() {
        return this.getSdkFactory().createWriter(this.getContentType());
    }

    @SdkTestInternalApi
    String getContentType() {
        return this.getContentTypeResolver().resolveContentType(this.metadata);
    }

    public <T> JsonResponseHandler<T> createResponseHandler(JsonOperationMetadata operationMetadata, Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller) {
        return this.getSdkFactory().createResponseHandler(operationMetadata, responseUnmarshaller);
    }

    public <ResponseT, ReturnT> SdkHttpResponseHandler<ReturnT> createAsyncStreamingResponseHandler(Unmarshaller<ResponseT, JsonUnmarshallerContext> responseUnmarshaller, AsyncResponseHandler<ResponseT, ReturnT> asyncResponseHandler) {
        return new UnmarshallingAsyncResponseHandler<Object, ReturnT>(asyncResponseHandler, sdkHttpResponse -> this.unmarshall(responseUnmarshaller, (SdkHttpFullResponse)sdkHttpResponse));
    }

    public <ResponseT, ReturnT> HttpResponseHandler<ReturnT> createStreamingResponseHandler(Unmarshaller<ResponseT, JsonUnmarshallerContext> responseUnmarshaller, StreamingResponseHandler<ResponseT, ReturnT> streamingResponseHandler) {
        return new UnmarshallingStreamingResponseHandler<Object, ReturnT>(streamingResponseHandler, httpResponse -> this.unmarshall(responseUnmarshaller, (HttpResponse)httpResponse));
    }

    private <ResponseT> ResponseT unmarshall(Unmarshaller<ResponseT, JsonUnmarshallerContext> responseUnmarshaller, SdkHttpFullResponse sdkHttpResponse) throws Exception {
        return this.unmarshall(responseUnmarshaller, SdkHttpResponseAdapter.adapt(false, null, sdkHttpResponse));
    }

    private <ResponseT> ResponseT unmarshall(Unmarshaller<ResponseT, JsonUnmarshallerContext> responseUnmarshaller, HttpResponse httpResponse) throws Exception {
        return responseUnmarshaller.unmarshall(new JsonUnmarshallerContextImpl(null, Collections.emptyMap(), httpResponse));
    }

    public HttpResponseHandler<AmazonServiceException> createErrorResponseHandler(JsonErrorResponseMetadata errorResponsMetadata) {
        return this.getSdkFactory().createErrorResponseHandler(this.errorUnmarshallers, errorResponsMetadata.getCustomErrorCodeFieldName());
    }

    private void createErrorUnmarshallers() {
        for (JsonErrorShapeMetadata errorMetadata : this.metadata.getErrorShapeMetadata()) {
            this.errorUnmarshallers.add(new JsonErrorUnmarshaller(errorMetadata.getModeledClass(), errorMetadata.getErrorCode()));
        }
        this.errorUnmarshallers.add(new JsonErrorUnmarshaller(this.metadata.getBaseServiceExceptionClass(), null));
    }

    private SdkStructuredJsonFactory getSdkFactory() {
        if (this.isCborEnabled()) {
            return SdkStructuredCborFactory.SDK_CBOR_FACTORY;
        }
        if (this.isIonEnabled()) {
            return this.isIonBinaryEnabled() ? SdkStructuredIonFactory.SDK_ION_BINARY_FACTORY : SdkStructuredIonFactory.SDK_ION_TEXT_FACTORY;
        }
        return SdkStructuredPlainJsonFactory.SDK_JSON_FACTORY;
    }

    private JsonContentTypeResolver getContentTypeResolver() {
        if (this.isCborEnabled()) {
            return JsonContentTypeResolver.CBOR;
        }
        if (this.isIonEnabled()) {
            return this.isIonBinaryEnabled() ? JsonContentTypeResolver.ION_BINARY : JsonContentTypeResolver.ION_TEXT;
        }
        return JsonContentTypeResolver.JSON;
    }

    private boolean isCborEnabled() {
        return this.metadata.isSupportsCbor() && AwsSystemSetting.AWS_CBOR_ENABLED.getBooleanValueOrThrow() != false;
    }

    private boolean isIonEnabled() {
        return this.metadata.isSupportsIon();
    }

    boolean isIonBinaryEnabled() {
        return AwsSystemSetting.AWS_BINARY_ION_ENABLED.getBooleanValueOrThrow();
    }
}

