/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.json;

import com.fasterxml.jackson.core.JsonFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.internal.http.CompositeErrorCodeParser;
import software.amazon.awssdk.internal.http.ErrorCodeParser;
import software.amazon.awssdk.internal.http.IonErrorCodeParser;
import software.amazon.awssdk.internal.http.JsonErrorCodeParser;
import software.amazon.awssdk.protocol.json.IonFactory;
import software.amazon.awssdk.protocol.json.SdkIonGenerator;
import software.amazon.awssdk.protocol.json.SdkStructuredJsonFactoryImpl;
import software.amazon.awssdk.protocol.json.StructuredJsonGenerator;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeIonUnmarshallers;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.util.ImmutableMapParameter;
import software.amazon.ion.IonSystem;
import software.amazon.ion.system.IonBinaryWriterBuilder;
import software.amazon.ion.system.IonSystemBuilder;
import software.amazon.ion.system.IonTextWriterBuilder;
import software.amazon.ion.system.IonWriterBuilder;

@SdkInternalApi
class SdkStructuredIonFactory
extends SdkStructuredJsonFactoryImpl {
    private static final IonSystem ION_SYSTEM = IonSystemBuilder.standard().build();
    private static final JsonFactory JSON_FACTORY = new IonFactory(ION_SYSTEM);
    private static final Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> UNMARSHALLERS = new ImmutableMapParameter.Builder<Class<BigDecimal>, SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller>().put(BigDecimal.class, SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller.getInstance()).put(BigInteger.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.BigIntegerIonUnmarshaller.getInstance())).put(Boolean.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.BooleanIonUnmarshaller.getInstance())).put(ByteBuffer.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.ByteBufferIonUnmarshaller.getInstance())).put(Byte.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.ByteIonUnmarshaller.getInstance())).put(Date.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.DateIonUnmarshaller.getInstance())).put(Double.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.DoubleIonUnmarshaller.getInstance())).put(Float.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.FloatIonUnmarshaller.getInstance())).put(Integer.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.IntegerIonUnmarshaller.getInstance())).put(Long.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.LongIonUnmarshaller.getInstance())).put(Short.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.ShortIonUnmarshaller.getInstance())).put(String.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.StringIonUnmarshaller.getInstance())).build();
    private static final IonBinaryWriterBuilder BINARY_WRITER_BUILDER = IonBinaryWriterBuilder.standard().immutable();
    public static final SdkStructuredIonFactory SDK_ION_BINARY_FACTORY = new SdkStructuredIonFactory(BINARY_WRITER_BUILDER);
    private static final IonTextWriterBuilder TEXT_WRITER_BUILDER = IonTextWriterBuilder.standard().immutable();
    public static final SdkStructuredIonFactory SDK_ION_TEXT_FACTORY = new SdkStructuredIonFactory(TEXT_WRITER_BUILDER);
    private final IonWriterBuilder builder;

    private SdkStructuredIonFactory(IonWriterBuilder builder) {
        super(JSON_FACTORY, UNMARSHALLERS);
        this.builder = builder;
    }

    @Override
    protected StructuredJsonGenerator createWriter(JsonFactory jsonFactory, String contentType) {
        return SdkIonGenerator.create(this.builder, contentType);
    }

    @Override
    protected ErrorCodeParser getErrorCodeParser(String customErrorCodeFieldName) {
        return new CompositeErrorCodeParser(new IonErrorCodeParser(ION_SYSTEM), new JsonErrorCodeParser(customErrorCodeFieldName));
    }
}

