/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.json;

import com.fasterxml.jackson.core.JsonFactory;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.internal.http.ErrorCodeParser;
import software.amazon.awssdk.internal.http.JsonErrorCodeParser;
import software.amazon.awssdk.internal.http.response.JsonErrorResponseHandler;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkStructuredJsonFactory;
import software.amazon.awssdk.protocol.json.StructuredJsonGenerator;
import software.amazon.awssdk.runtime.http.JsonErrorMessageParser;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.JsonErrorUnmarshaller;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

public abstract class SdkStructuredJsonFactoryImpl
implements SdkStructuredJsonFactory {
    private final JsonFactory jsonFactory;
    private final Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> unmarshallers;

    public SdkStructuredJsonFactoryImpl(JsonFactory jsonFactory, Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> unmarshallers) {
        this.jsonFactory = jsonFactory;
        this.unmarshallers = unmarshallers;
    }

    @Override
    public StructuredJsonGenerator createWriter(String contentType) {
        return this.createWriter(this.jsonFactory, contentType);
    }

    protected abstract StructuredJsonGenerator createWriter(JsonFactory var1, String var2);

    @Override
    public <T> JsonResponseHandler<T> createResponseHandler(JsonOperationMetadata operationMetadata, Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller) {
        return new JsonResponseHandler<T>(responseUnmarshaller, this.unmarshallers, this.jsonFactory, operationMetadata.isHasStreamingSuccessResponse(), operationMetadata.isPayloadJson());
    }

    @Override
    public JsonErrorResponseHandler createErrorResponseHandler(List<JsonErrorUnmarshaller> errorUnmarshallers, String customErrorCodeFieldName) {
        return new JsonErrorResponseHandler(errorUnmarshallers, this.getErrorCodeParser(customErrorCodeFieldName), JsonErrorMessageParser.DEFAULT_ERROR_MESSAGE_PARSER, this.jsonFactory);
    }

    protected ErrorCodeParser getErrorCodeParser(String customErrorCodeFieldName) {
        return new JsonErrorCodeParser(customErrorCodeFieldName);
    }
}

