/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.json.internal;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.json.internal.JsonMarshaller;
import software.amazon.awssdk.protocol.json.internal.JsonMarshallerContext;
import software.amazon.awssdk.protocol.json.internal.ValueToStringConverters;
import software.amazon.awssdk.runtime.transform.PathMarshallers;

@SdkInternalApi
public class SimpleTypePathMarshallers {
    public static final JsonMarshaller<String> STRING = new SimplePathMarshaller<String>(ValueToStringConverters.FROM_STRING, PathMarshallers.NON_GREEDY);
    public static final JsonMarshaller<Integer> INTEGER = new SimplePathMarshaller<Integer>(ValueToStringConverters.FROM_INTEGER, PathMarshallers.NON_GREEDY);
    public static final JsonMarshaller<Long> LONG = new SimplePathMarshaller<Long>(ValueToStringConverters.FROM_LONG, PathMarshallers.NON_GREEDY);
    public static final JsonMarshaller<String> GREEDY_STRING = new SimplePathMarshaller<String>(ValueToStringConverters.FROM_STRING, PathMarshallers.GREEDY);
    public static final JsonMarshaller<Void> NULL = (val2, context, paramName) -> {
        throw new IllegalArgumentException(String.format("Parameter '%s' must not be null", paramName));
    };

    private static class SimplePathMarshaller<T>
    implements JsonMarshaller<T> {
        private final ValueToStringConverters.ValueToString<T> converter;
        private final PathMarshallers.PathMarshaller pathMarshaller;

        private SimplePathMarshaller(ValueToStringConverters.ValueToString<T> converter, PathMarshallers.PathMarshaller pathMarshaller) {
            this.converter = converter;
            this.pathMarshaller = pathMarshaller;
        }

        @Override
        public void marshall(T val2, JsonMarshallerContext context, String paramName) {
            context.request().setResourcePath(this.pathMarshaller.marshall(context.request().getResourcePath(), paramName, (String)this.converter.apply(val2)));
        }
    }
}

