/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.internal.region.PartitionMetadataProvider;
import software.amazon.awssdk.internal.region.model.Partitions;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.RegionMetadata;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.utils.IoUtils;

@SdkInternalApi
public class RegionMetadataLoader {
    private static volatile PartitionMetadataProvider provider;
    private static final String PARTITIONS_RESOURCE_PATH = "software/amazon/awssdk/internal/region/endpoints.json";
    private static final String PARTITIONS_OVERRIDE_RESOURCE_PATH = "software/amazon/awssdk/partitions/override/endpoints.json";
    private static final ObjectMapper MAPPER;
    private static final ClassLoader CLASS_LOADER;

    protected static RegionMetadata getRegionMetadata(Region region) {
        if (provider == null) {
            RegionMetadataLoader.build();
        }
        return provider.getRegionMetadata(region);
    }

    protected static ServiceMetadata getServiceMetadata(String serviceEndpointPrefix) {
        if (provider == null) {
            RegionMetadataLoader.build();
        }
        return provider.getServiceMetadata(serviceEndpointPrefix);
    }

    protected static void build() {
        InputStream stream = CLASS_LOADER.getResourceAsStream(PARTITIONS_OVERRIDE_RESOURCE_PATH);
        if (stream != null) {
            provider = new PartitionMetadataProvider(RegionMetadataLoader.loadPartitionFromStream(stream, PARTITIONS_OVERRIDE_RESOURCE_PATH).getPartitions());
        } else {
            stream = CLASS_LOADER.getResourceAsStream(PARTITIONS_RESOURCE_PATH);
            if (stream == null) {
                throw new SdkClientException("Unable to load partition metadata from software/amazon/awssdk/internal/region/endpoints.json");
            }
            provider = new PartitionMetadataProvider(RegionMetadataLoader.loadPartitionFromStream(stream, PARTITIONS_RESOURCE_PATH).getPartitions());
        }
    }

    private static Partitions loadPartitionFromStream(InputStream stream, String location) {
        try {
            Partitions partitions = MAPPER.readValue(stream, Partitions.class);
            return partitions;
        }
        catch (IOException e) {
            throw new SdkClientException("Error while loading partitions file from " + location, e);
        }
        finally {
            IoUtils.closeQuietly(stream, null);
        }
    }

    static {
        MAPPER = new ObjectMapper().disable(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS).disable(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS).enable(JsonParser.Feature.ALLOW_COMMENTS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        CLASS_LOADER = RegionMetadataLoader.class.getClassLoader();
    }
}

