/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.providers;

import java.io.File;
import software.amazon.awssdk.AwsSystemSetting;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkTestInternalApi;
import software.amazon.awssdk.auth.profile.internal.AllProfiles;
import software.amazon.awssdk.auth.profile.internal.BasicProfile;
import software.amazon.awssdk.auth.profile.internal.BasicProfileConfigLoader;
import software.amazon.awssdk.profile.path.AwsProfileFileLocationProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.utils.StringUtils;

public class AwsProfileRegionProvider
extends AwsRegionProvider {
    private final String profileName;
    private final AwsProfileFileLocationProvider locationProvider;
    private final BasicProfileConfigLoader profileConfigLoader;

    public AwsProfileRegionProvider() {
        this(AwsSystemSetting.AWS_DEFAULT_PROFILE.getStringValueOrThrow());
    }

    public AwsProfileRegionProvider(String profileName) {
        this(profileName, AwsProfileFileLocationProvider.DEFAULT_CONFIG_LOCATION_PROVIDER, BasicProfileConfigLoader.INSTANCE);
    }

    @SdkTestInternalApi
    AwsProfileRegionProvider(String profileName, AwsProfileFileLocationProvider locationProvider, BasicProfileConfigLoader configLoader) {
        this.profileName = profileName;
        this.locationProvider = locationProvider;
        this.profileConfigLoader = configLoader;
    }

    @Override
    public Region getRegion() throws SdkClientException {
        BasicProfile profile;
        File configFile = this.locationProvider.getLocation();
        if (configFile != null && configFile.exists() && (profile = this.loadProfile(configFile)) != null && !StringUtils.isEmpty(profile.getRegion())) {
            return Region.of(profile.getRegion());
        }
        return null;
    }

    private BasicProfile loadProfile(File configFile) {
        AllProfiles allProfiles = this.profileConfigLoader.loadProfiles(configFile);
        return allProfiles.getProfile(this.profileName);
    }
}

