/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.auth.AwsCredentialsProviderChain;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;

public class AwsRegionProviderChain
extends AwsRegionProvider {
    private static final Log LOG = LogFactory.getLog(AwsCredentialsProviderChain.class);
    private final List<AwsRegionProvider> providers;

    public AwsRegionProviderChain(AwsRegionProvider ... providers) {
        this.providers = new ArrayList<AwsRegionProvider>(providers.length);
        Collections.addAll(this.providers, providers);
    }

    @Override
    public Region getRegion() throws SdkClientException {
        for (AwsRegionProvider provider : this.providers) {
            try {
                Region region = provider.getRegion();
                if (region == null) continue;
                return region;
            }
            catch (Exception e) {
                LOG.debug("Unable to load region from " + provider.toString() + ": " + e.getMessage());
            }
        }
        return null;
    }
}

