/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.retry.v2;

import software.amazon.awssdk.retry.v2.RetryCondition;
import software.amazon.awssdk.retry.v2.RetryPolicyContext;
import software.amazon.awssdk.util.ValidationUtils;

public class MaxNumberOfRetriesCondition
implements RetryCondition {
    private final int maxNumberOfRetries;

    public MaxNumberOfRetriesCondition(int maxNumberOfRetries) {
        this.maxNumberOfRetries = ValidationUtils.assertIsPositive(maxNumberOfRetries, "maxNumberOfRetries");
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        return context.retriesAttempted() < this.maxNumberOfRetries;
    }
}

