/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.runtime.endpoint;

import java.net.URI;
import java.net.URISyntaxException;
import software.amazon.awssdk.annotation.NotThreadSafe;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.runtime.endpoint.ServiceEndpointBuilder;

@NotThreadSafe
@SdkProtectedApi
public class DefaultServiceEndpointBuilder
extends ServiceEndpointBuilder {
    private final String serviceName;
    private final String protocol;
    private Region region;

    public DefaultServiceEndpointBuilder(String serviceName, String protocol) {
        this.serviceName = serviceName;
        this.protocol = protocol;
    }

    @Override
    public DefaultServiceEndpointBuilder withRegion(Region region) {
        if (region == null) {
            throw new IllegalArgumentException("Region cannot be null");
        }
        this.region = region;
        return this;
    }

    @Override
    public URI getServiceEndpoint() {
        ServiceMetadata serviceMetadata = ServiceMetadata.of(this.serviceName);
        return this.withProtocol(serviceMetadata.endpointFor(this.region));
    }

    private URI withProtocol(URI endpointWithoutProtocol) throws IllegalArgumentException {
        try {
            return new URI(String.format("%s://%s", this.protocol, endpointWithoutProtocol));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Region getRegion() {
        return this.region;
    }
}

