/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.runtime.io;

import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.annotation.NotThreadSafe;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.internal.io.Releasable;
import software.amazon.awssdk.runtime.io.ResettableInputStream;
import software.amazon.awssdk.runtime.io.SdkFilterInputStream;

@NotThreadSafe
@SdkProtectedApi
public class ReleasableInputStream
extends SdkFilterInputStream {
    private static final Log log = LogFactory.getLog(ReleasableInputStream.class);
    private boolean closeDisabled;

    protected ReleasableInputStream(InputStream is) {
        super(is);
    }

    public static ReleasableInputStream wrap(InputStream is) {
        if (is instanceof ReleasableInputStream) {
            return (ReleasableInputStream)is;
        }
        if (is instanceof FileInputStream) {
            return ResettableInputStream.newResettableInputStream((FileInputStream)is);
        }
        return new ReleasableInputStream(is);
    }

    @Override
    public final void close() {
        if (!this.closeDisabled) {
            this.doRelease();
        }
    }

    @Override
    public final void release() {
        this.doRelease();
    }

    private void doRelease() {
        block3: {
            try {
                this.in.close();
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("FYI", ex);
            }
        }
        if (this.in instanceof Releasable) {
            Releasable r = (Releasable)((Object)this.in);
            r.release();
        }
        this.abortIfNeeded();
    }

    public final boolean isCloseDisabled() {
        return this.closeDisabled;
    }

    public final <T extends ReleasableInputStream> T disableClose() {
        this.closeDisabled = true;
        ReleasableInputStream t = this;
        return (T)t;
    }
}

